//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  July 22, 2010
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

#pragma vector=DACDMA_VECTOR
__interrupt void DigitalToAnalog_DMA(void)
{

}

#pragma vector=PORT2_VECTOR
__interrupt void Port2_Change(void)
{

}

#pragma vector=USART1TX_VECTOR
__interrupt void USART1_Transmit(void)
{

}

#pragma vector=USART1RX_VECTOR
__interrupt void USART1_Receive(void)
{

}

#pragma vector=PORT1_VECTOR
__interrupt void PORT1_Change(void)
{

}

#pragma vector=TIMERA1_VECTOR
__interrupt void TimerA1(void)
{

switch (TAIV)
{
case TACCR1_CCIFG_SET:
  break;
case TACCR2_CCIFG_SET:
  break;
case TAIFG_SET:
  break;
}

}

#pragma vector=ADC12_VECTOR
__interrupt void AnalogToDigitalConverter(void)
{

}



#pragma vector=WDT_VECTOR
__interrupt void Watchdog_Timer(void)
{

}

#pragma vector=COMPARATORA_VECTOR
__interrupt void ComparatorA(void)
{

}

#pragma vector=TIMERB1_VECTOR
__interrupt void TimerB1(void)
{
switch (TBIV)
{
case TBCCR1_CCIFG_SET:
  TBCCR1 += Frequency[1];
  break;
case TBCCR2_CCIFG_SET:
  TBCCR2 += Frequency[2];
  break;
case TBCCR3_CCIFG_SET:
  TBCCR3 += Frequency[3];
  if (MoveSteps && (P4IN & 0x08))
    {
    StepsToMove -=1;
    if (!StepsToMove)
        {
        TBCCTL3 &= 0xFF0F;
        MoveSteps = false;
        }
    }
  break;
case TBCCR4_CCIFG_SET:
  TBCCR4 += Frequency[4];
  int TempPort4;
  TempPort4 = P4OUT;

if (MS_Direction)
  {
  switch (MS_Index & MS_MASK)
    {
      case MS_QUADRANT1:   //PHASE is 10
      TempPort4 |= PHASEA_8812;
      TempPort4 &= ~PHASEB_8812;
      break;
      case MS_QUADRANT2:  //PHASE is 11
      TempPort4 |= PHASEA_8812 + PHASEB_8812;
      break;
      case MS_QUADRANT3:  //PHASE is 01
      TempPort4 |= PHASEB_8812;
      TempPort4 &= ~PHASEA_8812;
      break;
      case MS_QUADRANT4:  //PHASE is 00
      TempPort4 &= ~(PHASEB_8812 + PHASEA_8812);
      break;
    }
  }
else
  {
  switch (MS_Index & MS_MASK)
    {
      case MS_QUADRANT1:   //PHASE is 11
      TempPort4 |= PHASEA_8812 + PHASEB_8812;
      break;
      case MS_QUADRANT2:  //PHASE is 10
      TempPort4 |= PHASEA_8812;
      TempPort4 &= ~PHASEB_8812;
      break;
      case MS_QUADRANT3:  //PHASE is 00
      TempPort4 &= ~(PHASEB_8812 + PHASEA_8812);
      break;
      case MS_QUADRANT4:  //PHASE is 01
      TempPort4 |= PHASEB_8812;
      TempPort4 &= ~PHASEA_8812;
      break;
    }
  }

  DAC12_0DAT = SineWave[MS_Index & (CURRENT_LEVELS - 1)];
  DAC12_1DAT = SineWave[(MS_Index + (CURRENT_LEVELS / 2)) & (CURRENT_LEVELS - 1)];
  P4OUT = TempPort4;
  MS_Index += 1;

  break;
case TBCCR5_CCIFG_SET:
  TBCCR5 += Frequency[5];
  int PhaseA, PhaseB, CurrentA, CurrentB, SPIData, FlippedData, i;
  PhaseA = MS_Index & 0x20;
  PhaseB = (MS_Index + 16) & 0x20;
  CurrentA = MS_Index & 0x1F;
  CurrentB = (MS_Index + 8) & 0x1F;
  SPIData = (CurrentB * 2^11 + CurrentA * 2^6 + PhaseB *2^5 + PhaseA* 2^4) + 1;
  FlippedData = 0;
  for (i = 0; i <=15; i++)
  {
    FlippedData += (SPIData & (2 * (15-i)) * 2^i);
  }
  DRV8826_SPI(FlippedData);
  break;
case TBCCR6_CCIFG_SET:
  break;
case TBIFG_SET:
  break;
}
}

#pragma vector=TIMERB0_VECTOR
__interrupt void TimerB0(void)
{
TBCCR0 += Frequency[0];
}

#pragma vector=NMI_VECTOR
__interrupt void NonMaskableInterrupt(void)
{

}

