LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY Sensors IS PORT (
	SCL : IN std_logic;
	SDA : INOUT std_logic;
	\MIC PWR\ : IN std_logic;
	\SDA HP\ : INOUT std_logic;
	\SCL HP\ : IN std_logic;
	\TMP RDY\ : OUT std_logic;
	\AUDIO DI\ : OUT std_logic;
	\DP7/AUDIO CLK\ : IN std_logic;
	\MPU PWR\ : INOUT std_logic;
	\MPU INT\ : OUT std_logic;
	REED : OUT std_logic
); 

END Sensors;



ARCHITECTURE STRUCTURE OF Sensors IS

-- COMPONENTS

COMPONENT \100nF\
	PORT (
	\1\ : INOUT std_logic;
	\2\ : INOUT std_logic
	); END COMPONENT;

COMPONENT BMP280
	PORT (
	GND : IN std_logic;
	CSB : IN std_logic;
	VDDIO : IN std_logic;
	SDI : INOUT std_logic;
	SCK : IN std_logic;
	SDO : INOUT std_logic;
	VDD : IN std_logic
	); END COMPONENT;

COMPONENT TMP007
	PORT (
	nALERT : OUT std_logic;
	SDA : INOUT std_logic;
	DGND : IN std_logic;
	AGND : IN std_logic;
	\V+\ : IN std_logic;
	ADR1 : IN std_logic;
	SCL : IN std_logic;
	ADR0 : IN std_logic
	); END COMPONENT;

COMPONENT HDC1000YPA
	PORT (
	GND : IN std_logic;
	SDA : INOUT std_logic;
	SCL : IN std_logic;
	VDD : IN std_logic;
	ADR0 : IN std_logic;
	ADR1 : IN std_logic;
	nDRDY : OUT std_logic;
	DNC : INOUT std_logic
	); END COMPONENT;

COMPONENT \SPH0641LM4H-1\
	PORT (
	VDD : IN std_logic;
	\SELECT\ : IN std_logic;
	CLOCK : IN std_logic;
	DATA : OUT std_logic;
	GND : IN std_logic
	); END COMPONENT;

COMPONENT OPT3001
	PORT (
	nINT : OUT std_logic;
	ADDR : IN std_logic;
	VDD : IN std_logic;
	GND : IN std_logic;
	\EGP/GND\ : IN std_logic;
	nCLK : IN std_logic;
	DATA : INOUT std_logic
	); END COMPONENT;

COMPONENT \MPU-9250\
	PORT (
	NC_6 : INOUT std_logic;
	AUX_DA : IN std_logic;
	AUX_CL : IN std_logic;
	VDDIO : IN std_logic;
	\AD0/SDO\ : INOUT std_logic;
	REGOUT : INOUT std_logic;
	FSYNC : IN std_logic;
	INT : IN std_logic;
	VDD : IN std_logic;
	GND : IN std_logic;
	RESV_19 : INOUT std_logic;
	RESV_1 : IN std_logic;
	RESV_20 : IN std_logic;
	nCS : IN std_logic;
	\SCL/SCLK\ : IN std_logic;
	\SDA/SDI\ : INOUT std_logic;
	EGP : IN std_logic;
	NC_14 : INOUT std_logic;
	NC_15 : INOUT std_logic;
	NC_16 : INOUT std_logic;
	NC_17 : INOUT std_logic;
	NC_2 : INOUT std_logic;
	NC_3 : INOUT std_logic;
	NC_4 : INOUT std_logic;
	NC_5 : INOUT std_logic
	); END COMPONENT;

COMPONENT \0\
	PORT (
	\1\ : INOUT std_logic;
	\2\ : INOUT std_logic
	); END COMPONENT;

COMPONENT \MK24-A\
	PORT (
	\2\ : INOUT std_logic;
	\1\ : INOUT std_logic
	); END COMPONENT;

-- SIGNALS

SIGNAL GND : std_logic;
SIGNAL N543563 : std_logic;
SIGNAL N537485 : std_logic;
SIGNAL N540621 : std_logic;
SIGNAL N546170 : std_logic;
SIGNAL N615347 : std_logic;
SIGNAL VDD : std_logic;

-- INSTANCE ATTRIBUTES

ATTRIBUTE \DATASHEET URL 2\:string;
ATTRIBUTE \DATASHEET URL 2\ of C21 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\:string;
ATTRIBUTE \CLIENT STATUS\ of C21 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\:string;
ATTRIBUTE \OLD FOOTPRINT\ of C21 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\:string;
ATTRIBUTE \PACKING SIZE\ of C21 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\:string;
ATTRIBUTE \BUDGET CURRENCY\ of C21 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\:string;
ATTRIBUTE \BUDGET PRICE\ of C21 : label is "0.008";
ATTRIBUTE CURRENT:string;
ATTRIBUTE CURRENT of C21 : label is "CIMAX";
ATTRIBUTE KNEE:string;
ATTRIBUTE KNEE of C21 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\:string;
ATTRIBUTE \COUNTRY OF ORIGIN\ of C21 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\:string;
ATTRIBUTE \MIN OPER TEMP\ of C21 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\:string;
ATTRIBUTE \PART NUMBER\ of C21 : label is "02-06085";
ATTRIBUTE DESCRIPTION:string;
ATTRIBUTE DESCRIPTION of C21 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST:string;
ATTRIBUTE DIST of C21 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\:string;
ATTRIBUTE \VENDOR PART STATUS\ of C21 : label is "ACTIVE";
ATTRIBUTE \BU NAME\:string;
ATTRIBUTE \BU NAME\ of C21 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\:string;
ATTRIBUTE \MIN TOL\ of C21 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE:string;
ATTRIBUTE PSPICETEMPLATE of C21 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE:string;
ATTRIBUTE SLOPE of C21 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\:string;
ATTRIBUTE \PCB PACKAGE\ of C21 : label is "0201";
ATTRIBUTE \MAX TOL\:string;
ATTRIBUTE \MAX TOL\ of C21 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\:string;
ATTRIBUTE \DIELECTRIC TYPE\ of C21 : label is "X5R";
ATTRIBUTE MPN:string;
ATTRIBUTE MPN of C21 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE WEIGHT:string;
ATTRIBUTE WEIGHT of C21 : label is "0.00033g";
ATTRIBUTE CAPACITANCE:string;
ATTRIBUTE CAPACITANCE of C21 : label is "100nF";
ATTRIBUTE MANUFACTURER:string;
ATTRIBUTE MANUFACTURER of C21 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\:string;
ATTRIBUTE \MPN STATUS\ of C21 : label is "ACTIVE";
ATTRIBUTE \PACKING TYPE\:string;
ATTRIBUTE \PACKING TYPE\ of C21 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR:string;
ATTRIBUTE VENDOR of C21 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\:string;
ATTRIBUTE \AUTODOC FILE\ of C21 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\:string;
ATTRIBUTE \LEAD TIME\ of C21 : label is "17";
ATTRIBUTE REVISION:string;
ATTRIBUTE REVISION of C21 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\:string;
ATTRIBUTE \MAX OPER TEMP\ of C21 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\:string;
ATTRIBUTE \RTD VOLTAGE\ of C21 : label is "10V";
ATTRIBUTE \LAST TIME BUY\:string;
ATTRIBUTE \LAST TIME BUY\ of C21 : label is "N/A";
ATTRIBUTE \NOTE STATUS\:string;
ATTRIBUTE \NOTE STATUS\ of C21 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\:string;
ATTRIBUTE \VENDOR PART NUMBER\ of C21 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP:string;
ATTRIBUTE MAX_TEMP of C21 : label is "CTMAX";
ATTRIBUTE TC1:string;
ATTRIBUTE TC1 of C21 : label is "0";
ATTRIBUTE TC2:string;
ATTRIBUTE TC2 of C21 : label is "0";
ATTRIBUTE \DATASHEET URL 1\:string;
ATTRIBUTE \DATASHEET URL 1\ of C21 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE ALT_SYMBOLS:string;
ATTRIBUTE ALT_SYMBOLS of C21 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\:string;
ATTRIBUTE \MOUNTING TYPE\ of C21 : label is "SMD";
ATTRIBUTE \PART TYPE\:string;
ATTRIBUTE \PART TYPE\ of C21 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\:string;
ATTRIBUTE \ROHS STATUS\ of C21 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of C23 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C23 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C23 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\ of C23 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C23 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C23 : label is "0.008";
ATTRIBUTE CURRENT of C23 : label is "CIMAX";
ATTRIBUTE KNEE of C23 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C23 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\ of C23 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C23 : label is "02-06085";
ATTRIBUTE DESCRIPTION of C23 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST of C23 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of C23 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of C23 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of C23 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C23 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C23 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C23 : label is "0201";
ATTRIBUTE \MAX TOL\ of C23 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C23 : label is "X5R";
ATTRIBUTE MPN of C23 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE CAPACITANCE of C23 : label is "100nF";
ATTRIBUTE MANUFACTURER of C23 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of C23 : label is "ACTIVE";
ATTRIBUTE WEIGHT of C23 : label is "0.00033g";
ATTRIBUTE \PACKING TYPE\ of C23 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR of C23 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\ of C23 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\ of C23 : label is "17";
ATTRIBUTE REVISION of C23 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of C23 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C23 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C23 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C23 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C23 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C23 : label is "CTMAX";
ATTRIBUTE TC1 of C23 : label is "0";
ATTRIBUTE TC2 of C23 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C23 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE ALT_SYMBOLS of C23 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C23 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C23 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of C23 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of C24 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C24 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C24 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\ of C24 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C24 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C24 : label is "0.008";
ATTRIBUTE CURRENT of C24 : label is "CIMAX";
ATTRIBUTE KNEE of C24 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C24 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\ of C24 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C24 : label is "02-06085";
ATTRIBUTE DESCRIPTION of C24 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST of C24 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of C24 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of C24 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of C24 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C24 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C24 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C24 : label is "0201";
ATTRIBUTE \MAX TOL\ of C24 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C24 : label is "X5R";
ATTRIBUTE MPN of C24 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE CAPACITANCE of C24 : label is "100nF";
ATTRIBUTE MANUFACTURER of C24 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of C24 : label is "ACTIVE";
ATTRIBUTE WEIGHT of C24 : label is "0.00033g";
ATTRIBUTE \PACKING TYPE\ of C24 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR of C24 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\ of C24 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\ of C24 : label is "17";
ATTRIBUTE REVISION of C24 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of C24 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C24 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C24 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C24 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C24 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C24 : label is "CTMAX";
ATTRIBUTE TC1 of C24 : label is "0";
ATTRIBUTE TC2 of C24 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C24 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE ALT_SYMBOLS of C24 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C24 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C24 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of C24 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of C25 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C25 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C25 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\ of C25 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C25 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C25 : label is "0.008";
ATTRIBUTE CURRENT of C25 : label is "CIMAX";
ATTRIBUTE KNEE of C25 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C25 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\ of C25 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C25 : label is "02-06085";
ATTRIBUTE DESCRIPTION of C25 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST of C25 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of C25 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of C25 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of C25 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C25 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C25 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C25 : label is "0201";
ATTRIBUTE \MAX TOL\ of C25 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C25 : label is "X5R";
ATTRIBUTE MPN of C25 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE CAPACITANCE of C25 : label is "100nF";
ATTRIBUTE MANUFACTURER of C25 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of C25 : label is "ACTIVE";
ATTRIBUTE WEIGHT of C25 : label is "0.00033g";
ATTRIBUTE \PACKING TYPE\ of C25 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR of C25 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\ of C25 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\ of C25 : label is "17";
ATTRIBUTE REVISION of C25 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of C25 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C25 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C25 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C25 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C25 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C25 : label is "CTMAX";
ATTRIBUTE TC1 of C25 : label is "0";
ATTRIBUTE TC2 of C25 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C25 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE ALT_SYMBOLS of C25 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C25 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C25 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of C25 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of U3 : label is "http://ae-bst.resource.bosch.com/media/products/dokumente/bmp280/bosch_sensortec_flyer_bmp280_onl.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of U3 : label is "XDCR_BMP280N";
ATTRIBUTE MSL:string;
ATTRIBUTE MSL of U3 : label is "1";
ATTRIBUTE \MIN OPER TEMP\ of U3 : label is "0DEGC";
ATTRIBUTE DESCRIPTION of U3 : label is "IC, TRANSDUCER PRESSURE, 300 to 110 hPa, 1.71V TO 3.6V, LGA8, SMD";
ATTRIBUTE \PART NUMBER\ of U3 : label is "18-28617";
ATTRIBUTE MPN of U3 : label is "BMP280";
ATTRIBUTE \PCB PACKAGE\ of U3 : label is "LGA8";
ATTRIBUTE \ESD LEVEL\:string;
ATTRIBUTE \ESD LEVEL\ of U3 : label is "CDM 500V";
ATTRIBUTE DESIGNED_DATE:string;
ATTRIBUTE DESIGNED_DATE of U3 : label is "2013-06-03";
ATTRIBUTE \MPN STATUS\ of U3 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of U3 : label is "BOSCH";
ATTRIBUTE \AUTODOC FILE\ of U3 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89274";
ATTRIBUTE DESIGNED_BY:string;
ATTRIBUTE DESIGNED_BY of U3 : label is "Artur Bielinski";
ATTRIBUTE \RTD VOLTAGE\ of U3 : label is "1.71V TO 3.6V";
ATTRIBUTE \MAX OPER TEMP\ of U3 : label is "+65DEGC";
ATTRIBUTE REVISION of U3 : label is "R001";
ATTRIBUTE \NOTE STATUS\ of U3 : label is "PREFERRED";
ATTRIBUTE \ROHS STATUS\ of U3 : label is "ROHS_COMPLIANT";
ATTRIBUTE FREQUENCY:string;
ATTRIBUTE FREQUENCY of U3 : label is "120Hz";
ATTRIBUTE \PART TYPE\ of U3 : label is "IC\TRANSDUCER\PRESSURE";
ATTRIBUTE \MOUNTING TYPE\ of U3 : label is "SMD";
ATTRIBUTE \DATASHEET URL 2\ of C26 : label is "http://psearch.murata.com/capacitor/product/GRM033R71A103KA01%23.pdf";
ATTRIBUTE \MTBF STANDARD\:string;
ATTRIBUTE \MTBF STANDARD\ of C26 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of C26 : label is "CAPC0603X35N,0201";
ATTRIBUTE MSL of C26 : label is "1";
ATTRIBUTE \PACKING SIZE\ of C26 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C26 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C26 : label is "0.005";
ATTRIBUTE \LIFECYCLE STATUS\:string;
ATTRIBUTE \LIFECYCLE STATUS\ of C26 : label is "GROWTH";
ATTRIBUTE CURRENT of C26 : label is "CIMAX";
ATTRIBUTE KNEE of C26 : label is "CBMAX";
ATTRIBUTE \MIN OPER TEMP\ of C26 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C26 : label is "02-00599";
ATTRIBUTE DESCRIPTION of C26 : label is "CAPACITOR, CERAMIC X5R, 10nF, 10V, -10%/+10%, -55DEGC/+125DEGC, 0201, SMD";
ATTRIBUTE DIST of C26 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of C26 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C26 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C26 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C26 : label is "0201";
ATTRIBUTE \MAX TOL\ of C26 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C26 : label is "X5R";
ATTRIBUTE MPN of C26 : label is "GRM033R71A103KA01D";
ATTRIBUTE \ESD LEVEL\ of C26 : label is "N/A";
ATTRIBUTE FPLIST:string;
ATTRIBUTE FPLIST of C26 : label is "CAPC0603X35N,CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE CAPACITANCE of C26 : label is "10nF";
ATTRIBUTE MANUFACTURER of C26 : label is "MURATA";
ATTRIBUTE \MPN STATUS\ of C26 : label is "ACTIVE";
ATTRIBUTE WEIGHT of C26 : label is "0.00033g";
ATTRIBUTE \PACKING TYPE\ of C26 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of C26 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=49750";
ATTRIBUTE MTBF:string;
ATTRIBUTE MTBF of C26 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of C26 : label is "12";
ATTRIBUTE REVISION of C26 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of C26 : label is "+125DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C26 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C26 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C26 : label is "PREFERRED";
ATTRIBUTE \DEFINIED QUALITY\:string;
ATTRIBUTE \DEFINIED QUALITY\ of C26 : label is "INDUSTRIAL";
ATTRIBUTE MAX_TEMP of C26 : label is "CTMAX";
ATTRIBUTE TC1 of C26 : label is "0";
ATTRIBUTE TC2 of C26 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C26 : label is "http://search.murata.co.jp/Ceramy/image/img/w_hinm/L0005E.pdf";
ATTRIBUTE ALT_SYMBOLS of C26 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C26 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C26 : label is "CAPACITOR\CERAMIC\0201";
ATTRIBUTE \ROHS STATUS\ of C26 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of U4 : label is "http://www.ti.com/lit/ds/symlink/tmp007.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of U4 : label is "BGAFC8C50P187X189X63";
ATTRIBUTE MSL of U4 : label is "2";
ATTRIBUTE \BUDGET CURRENCY\ of U4 : label is "USD";
ATTRIBUTE \BUDGET PRICE\ of U4 : label is "1.9";
ATTRIBUTE \MIN OPER TEMP\ of U4 : label is "-40DEGC";
ATTRIBUTE DESIGN_DATE:string;
ATTRIBUTE DESIGN_DATE of U4 : label is "2014-05-27";
ATTRIBUTE DESCRIPTION of U4 : label is "IC, TRANSDUCER, INFRARED THERMOPILE SENSOR, 2.5V TO 5.5V, DSBGA8, SMD";
ATTRIBUTE \PART NUMBER\ of U4 : label is "18-29441";
ATTRIBUTE MPN of U4 : label is "TMP007AIYZFR";
ATTRIBUTE \PCB PACKAGE\ of U4 : label is "DSBGA8";
ATTRIBUTE FPLIST of U4 : label is "BGAFC8C50P187X189X63,";
ATTRIBUTE \MPN STATUS\ of U4 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of U4 : label is "TEXAS INSTRUMENTS";
ATTRIBUTE \AUTODOC FILE\ of U4 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96282";
ATTRIBUTE DESIGNED_BY of U4 : label is "Artur Bielinski";
ATTRIBUTE \RTD VOLTAGE\ of U4 : label is "2.5V TO 5.5V";
ATTRIBUTE \MAX OPER TEMP\ of U4 : label is "+125DEGC";
ATTRIBUTE REVISION of U4 : label is "R001";
ATTRIBUTE \NOTE STATUS\ of U4 : label is "PREFERRED";
ATTRIBUTE \DATASHEET URL 1\ of U4 : label is "N/A";
ATTRIBUTE \ROHS STATUS\ of U4 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of U4 : label is "IC\TRANSDUCER\TEMPERATURE";
ATTRIBUTE \MOUNTING TYPE\ of U4 : label is "SMD";
ATTRIBUTE \DATASHEET URL 2\ of C27 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C27 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C27 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\ of C27 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C27 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C27 : label is "0.008";
ATTRIBUTE CURRENT of C27 : label is "CIMAX";
ATTRIBUTE KNEE of C27 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C27 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\ of C27 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C27 : label is "02-06085";
ATTRIBUTE DESCRIPTION of C27 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST of C27 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of C27 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of C27 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of C27 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C27 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C27 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C27 : label is "0201";
ATTRIBUTE \MAX TOL\ of C27 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C27 : label is "X5R";
ATTRIBUTE MPN of C27 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE CAPACITANCE of C27 : label is "100nF";
ATTRIBUTE MANUFACTURER of C27 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of C27 : label is "ACTIVE";
ATTRIBUTE WEIGHT of C27 : label is "0.00033g";
ATTRIBUTE \PACKING TYPE\ of C27 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR of C27 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\ of C27 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\ of C27 : label is "17";
ATTRIBUTE REVISION of C27 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of C27 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C27 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C27 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C27 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C27 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C27 : label is "CTMAX";
ATTRIBUTE TC1 of C27 : label is "0";
ATTRIBUTE TC2 of C27 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C27 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE ALT_SYMBOLS of C27 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C27 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C27 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of C27 : label is "ROHS_COMPLIANT";
ATTRIBUTE \CLIENT STATUS\ of C28 : label is "UNDER_REVIEW";
ATTRIBUTE \DATASHEET URL 2\ of C28 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of C28 : label is "CAPC0603X35N";
ATTRIBUTE \BUDGET PRICE\ of C28 : label is "0.008";
ATTRIBUTE \BUDGET CURRENCY\ of C28 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of C28 : label is "15000";
ATTRIBUTE CURRENT of C28 : label is "CIMAX";
ATTRIBUTE KNEE of C28 : label is "CBMAX";
ATTRIBUTE \MIN OPER TEMP\ of C28 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C28 : label is "MISSING INFO";
ATTRIBUTE \PART NUMBER\ of C28 : label is "02-06085";
ATTRIBUTE DESCRIPTION of C28 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST of C28 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of C28 : label is "-10%";
ATTRIBUTE \BU NAME\ of C28 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of C28 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of C28 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C28 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C28 : label is "0201";
ATTRIBUTE \MAX TOL\ of C28 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C28 : label is "X5R";
ATTRIBUTE MPN of C28 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE WEIGHT of C28 : label is "0.00033g";
ATTRIBUTE CAPACITANCE of C28 : label is "100nF";
ATTRIBUTE MANUFACTURER of C28 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of C28 : label is "ACTIVE";
ATTRIBUTE \AUTODOC FILE\ of C28 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE VENDOR of C28 : label is "MURATA";
ATTRIBUTE \PACKING TYPE\ of C28 : label is "TAPE_&_REEL";
ATTRIBUTE \LEAD TIME\ of C28 : label is "17";
ATTRIBUTE REVISION of C28 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of C28 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C28 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C28 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C28 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C28 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C28 : label is "CTMAX";
ATTRIBUTE TC1 of C28 : label is "0";
ATTRIBUTE TC2 of C28 : label is "0";
ATTRIBUTE ALT_SYMBOLS of C28 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C28 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C28 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of C28 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of C28 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE \DATASHEET URL 2\ of U5 : label is "http://www.ti.com/lit/ds/symlink/hdc1000.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of U5 : label is "BGAFC8C50P159X204X68";
ATTRIBUTE \BUDGET PRICE\ of U5 : label is "2.2";
ATTRIBUTE \BUDGET CURRENCY\ of U5 : label is "USD";
ATTRIBUTE \PACKING SIZE\ of U5 : label is "3000";
ATTRIBUTE MSL of U5 : label is "1";
ATTRIBUTE \MIN OPER TEMP\ of U5 : label is "-20DEGC";
ATTRIBUTE \PART NUMBER\ of U5 : label is "18-31481";
ATTRIBUTE DESCRIPTION of U5 : label is "IC, TRANSDUCER, LOW POWER, HIGH ACCURACY DIGITAL HUMIDITY SENSOR WITH INTEGRATED TEMPERATURE SENSOR, 2.7V TO 5.5V, DSBGA8, SMD";
ATTRIBUTE \PCB PACKAGE\ of U5 : label is "DSBGA8";
ATTRIBUTE MPN of U5 : label is "HDC1000YPAR";
ATTRIBUTE FPLIST of U5 : label is "BGAFC8C50P159X204X68,";
ATTRIBUTE MANUFACTURER of U5 : label is "TEXAS INSTRUMENTS";
ATTRIBUTE \MPN STATUS\ of U5 : label is "ACTIVE";
ATTRIBUTE WEIGHT of U5 : label is "0.003482976g";
ATTRIBUTE \PACKING TYPE\ of U5 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of U5 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=103605";
ATTRIBUTE REVISION of U5 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of U5 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of U5 : label is "2.7V TO 5.5V";
ATTRIBUTE \NOTE STATUS\ of U5 : label is "PREFERRED";
ATTRIBUTE \MOUNTING TYPE\ of U5 : label is "SMD";
ATTRIBUTE \PART TYPE\ of U5 : label is "IC\TRANSDUCER\HUMIDITY";
ATTRIBUTE \ROHS STATUS\ of U5 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of U5 : label is "N/A";
ATTRIBUTE \DATASHEET URL 2\ of C29 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C29 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C29 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\ of C29 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C29 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C29 : label is "0.008";
ATTRIBUTE CURRENT of C29 : label is "CIMAX";
ATTRIBUTE KNEE of C29 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C29 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\ of C29 : label is "-55DEGC";
ATTRIBUTE DESCRIPTION of C29 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE \PART NUMBER\ of C29 : label is "02-06085";
ATTRIBUTE DIST of C29 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of C29 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of C29 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of C29 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C29 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C29 : label is "CSMAX";
ATTRIBUTE MPN of C29 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE \DIELECTRIC TYPE\ of C29 : label is "X5R";
ATTRIBUTE \MAX TOL\ of C29 : label is "+10%";
ATTRIBUTE \PCB PACKAGE\ of C29 : label is "0201";
ATTRIBUTE WEIGHT of C29 : label is "0.00033g";
ATTRIBUTE \MPN STATUS\ of C29 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of C29 : label is "MANUFACTURER SELECTION";
ATTRIBUTE CAPACITANCE of C29 : label is "100nF";
ATTRIBUTE \PACKING TYPE\ of C29 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR of C29 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\ of C29 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\ of C29 : label is "17";
ATTRIBUTE \RTD VOLTAGE\ of C29 : label is "10V";
ATTRIBUTE \MAX OPER TEMP\ of C29 : label is "+85DEGC";
ATTRIBUTE REVISION of C29 : label is "R002";
ATTRIBUTE \LAST TIME BUY\ of C29 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C29 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C29 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C29 : label is "CTMAX";
ATTRIBUTE TC1 of C29 : label is "0";
ATTRIBUTE TC2 of C29 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C29 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE \ROHS STATUS\ of C29 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of C29 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \MOUNTING TYPE\ of C29 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of C29 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \OLD FOOTPRINT\ of U6 : label is "MIC_SPH0641LM4H-1AN";
ATTRIBUTE \MIN OPER TEMP\ of U6 : label is "-40DEGC";
ATTRIBUTE DESIGN_DATE of U6 : label is "2013-07-02";
ATTRIBUTE DESCRIPTION of U6 : label is "IC, DIGITAL, MICROPHONE WITH MULTIPLE PERFORMANCE MODE, 1.62V TO 3.6V, SMD";
ATTRIBUTE \PART NUMBER\ of U6 : label is "18-28648";
ATTRIBUTE MPN of U6 : label is "SPH0641LM4H-1";
ATTRIBUTE FPLIST of U6 : label is "MIC_SPH0641LM4H-1AN,";
ATTRIBUTE \MPN STATUS\ of U6 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of U6 : label is "KNOWLES";
ATTRIBUTE \AUTODOC FILE\ of U6 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89371";
ATTRIBUTE DESIGNED_BY of U6 : label is "Artur Bielinski";
ATTRIBUTE \RTD VOLTAGE\ of U6 : label is "1.62V TO 3.6V";
ATTRIBUTE \MAX OPER TEMP\ of U6 : label is "+100DEGC";
ATTRIBUTE REVISION of U6 : label is "R002";
ATTRIBUTE \NOTE STATUS\ of U6 : label is "PREFERRED";
ATTRIBUTE \ROHS STATUS\ of U6 : label is "ROHS_COMPLIANT";
ATTRIBUTE FREQUENCY of U6 : label is "2.4MHz";
ATTRIBUTE \PART TYPE\ of U6 : label is "IC\DIGITAL\OTHER";
ATTRIBUTE \MOUNTING TYPE\ of U6 : label is "SMD";
ATTRIBUTE \DATASHEET URL 2\ of U7 : label is "N/A";
ATTRIBUTE \MTBF STANDARD\ of U7 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of U7 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of U7 : label is "SON65P200X200X65-7N";
ATTRIBUTE MSL of U7 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of U7 : label is "N/A";
ATTRIBUTE \BUDGET CURRENCY\ of U7 : label is "N/A";
ATTRIBUTE \BUDGET PRICE\ of U7 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\ of U7 : label is "N/A";
ATTRIBUTE \COUNTRY OF ORIGIN\ of U7 : label is "MISSING INFO";
ATTRIBUTE DESIGN_DATE of U7 : label is "2014-06-27";
ATTRIBUTE CLASS:string;
ATTRIBUTE CLASS of U7 : label is "IC";
ATTRIBUTE DESCRIPTION of U7 : label is "IC, TRANSDUCER, AMBIENT LIGHT SENSOR, OPT3001, SON6, SMD";
ATTRIBUTE \PART NUMBER\ of U7 : label is "18-28621";
ATTRIBUTE \BU NAME\ of U7 : label is "TEXAS INSTRUMENTS NORWAY";
ATTRIBUTE \VENDOR PART STATUS\ of U7 : label is "ACTIVE";
ATTRIBUTE MPN of U7 : label is "OPT3001";
ATTRIBUTE \PCB PACKAGE\ of U7 : label is "SON6";
ATTRIBUTE \ESD LEVEL\ of U7 : label is "N/A";
ATTRIBUTE WEIGHT of U7 : label is "N/A";
ATTRIBUTE \MPN STATUS\ of U7 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of U7 : label is "TEXAS INSTRUMENTS";
ATTRIBUTE \AUTODOC FILE\ of U7 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89288";
ATTRIBUTE VENDOR of U7 : label is "TEXAS INSTRUMENTS";
ATTRIBUTE \PACKING TYPE\ of U7 : label is "N/A";
ATTRIBUTE MTBF of U7 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of U7 : label is "N/A";
ATTRIBUTE DESIGNED_BY of U7 : label is "Artur Bielinski";
ATTRIBUTE \MAX OPER TEMP\ of U7 : label is "N/A";
ATTRIBUTE REVISION of U7 : label is "R004";
ATTRIBUTE \LAST TIME BUY\ of U7 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of U7 : label is "PREFERRED";
ATTRIBUTE \DEFINIED QUALITY\ of U7 : label is "COMMERCIAL";
ATTRIBUTE \VENDOR PART NUMBER\ of U7 : label is "OPT3001";
ATTRIBUTE \DATASHEET URL 1\ of U7 : label is "http://www.ti.com/lit/ds/symlink/opt3001.pdf";
ATTRIBUTE \ROHS STATUS\ of U7 : label is "MISSING_INFO";
ATTRIBUTE \PART TYPE\ of U7 : label is "IC\TRANSDUCER\LIGHT";
ATTRIBUTE \MOUNTING TYPE\ of U7 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of U7 : label is "SON65P200X200X65-7L,SON65P200X200X65-7M";
ATTRIBUTE \MTBF STANDARD\ of U8 : label is "N/A";
ATTRIBUTE \DATASHEET URL 2\ of U8 : label is "http://www.invensense.com/mems/gyro/documents/PS-MPU-9250A-01.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of U8 : label is "QFNFC40P300X300X105-25N";
ATTRIBUTE \BUDGET PRICE\ of U8 : label is "8.30060";
ATTRIBUTE \BUDGET CURRENCY\ of U8 : label is "USD";
ATTRIBUTE \PACKING SIZE\ of U8 : label is "5000";
ATTRIBUTE MSL of U8 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\ of U8 : label is "-40DEGC";
ATTRIBUTE DESIGN_DATE of U8 : label is "2014-05-27";
ATTRIBUTE \PART NUMBER\ of U8 : label is "18-29442";
ATTRIBUTE DESCRIPTION of U8 : label is "IC, TRANSDUCER, 3-AXIS ACCELEROMETER, 3-AXIS GYROSCOPE, 2.4V TO 3.6V, QFN24, SMD";
ATTRIBUTE \PCB PACKAGE\ of U8 : label is "QFN24";
ATTRIBUTE MPN of U8 : label is "MPU-9250";
ATTRIBUTE FPLIST of U8 : label is "QFNFC40P300X300X105-25N,QFNFC40P300X300X105-25L,QFNFC40P300X300X105-25M";
ATTRIBUTE \ESD LEVEL\ of U8 : label is "HBM 2kV";
ATTRIBUTE MANUFACTURER of U8 : label is "INVENSENSE";
ATTRIBUTE \MPN STATUS\ of U8 : label is "ACTIVE";
ATTRIBUTE WEIGHT of U8 : label is "N/A";
ATTRIBUTE \PACKING TYPE\ of U8 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of U8 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96283";
ATTRIBUTE \LEAD TIME\ of U8 : label is "N/A";
ATTRIBUTE MTBF of U8 : label is "N/A";
ATTRIBUTE DESIGNED_BY of U8 : label is "Artur Bielinski";
ATTRIBUTE REVISION of U8 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of U8 : label is "+105DEGC";
ATTRIBUTE \RTD VOLTAGE\ of U8 : label is "2.4V TO 3.6V";
ATTRIBUTE \NOTE STATUS\ of U8 : label is "PREFERRED";
ATTRIBUTE \DEFINIED QUALITY\ of U8 : label is "MILITARY";
ATTRIBUTE ALT_SYMBOLS of U8 : label is "QFNFC40P300X300X105-25L,QFNFC40P300X300X105-25M";
ATTRIBUTE \MOUNTING TYPE\ of U8 : label is "SMD";
ATTRIBUTE \PART TYPE\ of U8 : label is "IC\TRANSDUCER\ACCELERATION";
ATTRIBUTE \ROHS STATUS\ of U8 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of U8 : label is "http://www.invensense.com/mems/gyro/mpu9250.html";
ATTRIBUTE \DATASHEET URL 2\ of C31 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C31 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C31 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\ of C31 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C31 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C31 : label is "0.008";
ATTRIBUTE CURRENT of C31 : label is "CIMAX";
ATTRIBUTE KNEE of C31 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C31 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\ of C31 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C31 : label is "02-06085";
ATTRIBUTE DESCRIPTION of C31 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST of C31 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of C31 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of C31 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of C31 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C31 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C31 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C31 : label is "0201";
ATTRIBUTE \MAX TOL\ of C31 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C31 : label is "X5R";
ATTRIBUTE MPN of C31 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE CAPACITANCE of C31 : label is "100nF";
ATTRIBUTE MANUFACTURER of C31 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of C31 : label is "ACTIVE";
ATTRIBUTE WEIGHT of C31 : label is "0.00033g";
ATTRIBUTE \PACKING TYPE\ of C31 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR of C31 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\ of C31 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\ of C31 : label is "17";
ATTRIBUTE REVISION of C31 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of C31 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C31 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C31 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C31 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C31 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C31 : label is "CTMAX";
ATTRIBUTE TC1 of C31 : label is "0";
ATTRIBUTE TC2 of C31 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C31 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE ALT_SYMBOLS of C31 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C31 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C31 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of C31 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of R11 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of R11 : label is "UNDER_REVIEW";
ATTRIBUTE \MAX TC\:string;
ATTRIBUTE \MAX TC\ of R11 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R11 : label is "RESC0603X35N,0201";
ATTRIBUTE \MIN TC\:string;
ATTRIBUTE \MIN TC\ of R11 : label is "N/A";
ATTRIBUTE VOLTAGE:string;
ATTRIBUTE VOLTAGE of R11 : label is "RVMAX";
ATTRIBUTE \LIFECYCLE STATUS\ of R11 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of R11 : label is "0.009";
ATTRIBUTE \BUDGET CURRENCY\ of R11 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of R11 : label is "10000";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R11 : label is "TAIWAN,ISRAEL";
ATTRIBUTE \MIN OPER TEMP\ of R11 : label is "-55DEGC";
ATTRIBUTE \RTD POWER\:string;
ATTRIBUTE \RTD POWER\ of R11 : label is "0.05W";
ATTRIBUTE \PART NUMBER\ of R11 : label is "01-04043";
ATTRIBUTE DESCRIPTION of R11 : label is "RESISTOR, THICK FILM, 0, 0.05W, 30V, -55DEGC/+155DEGC, 0201, SMD";
ATTRIBUTE DIST of R11 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of R11 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of R11 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of R11 : label is "N/A";
ATTRIBUTE PSPICETEMPLATE of R11 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R11 : label is "0201";
ATTRIBUTE \MAX TOL\ of R11 : label is "N/A";
ATTRIBUTE MPN of R11 : label is "RESISTOR_0201_0_+/-1%_30V_0.05W_M_+/-100PPM";
ATTRIBUTE WEIGHT of R11 : label is "0.00017g";
ATTRIBUTE \RESISTOR TYPE\:string;
ATTRIBUTE \RESISTOR TYPE\ of R11 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER of R11 : label is "Manufacturer selection";
ATTRIBUTE \MPN STATUS\ of R11 : label is "ACTIVE";
ATTRIBUTE VENDOR of R11 : label is "VISHAY";
ATTRIBUTE RESISTANCE:string;
ATTRIBUTE RESISTANCE of R11 : label is "0";
ATTRIBUTE \PACKING TYPE\ of R11 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of R11 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=58850";
ATTRIBUTE \LEAD TIME\ of R11 : label is "10";
ATTRIBUTE REVISION of R11 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of R11 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\ of R11 : label is "30V";
ATTRIBUTE \LAST TIME BUY\ of R11 : label is "N/A";
ATTRIBUTE \RTD CURRENT\:string;
ATTRIBUTE \RTD CURRENT\ of R11 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R11 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of R11 : label is "CRCW02010000Z0ED";
ATTRIBUTE TC1 of R11 : label is "0";
ATTRIBUTE MAX_TEMP of R11 : label is "RTMAX";
ATTRIBUTE TC2 of R11 : label is "0";
ATTRIBUTE POWER:string;
ATTRIBUTE POWER of R11 : label is "RMAX";
ATTRIBUTE \DATASHEET URL 1\ of R11 : label is "http://www.vishay.com/docs/20052/crcw0201e3.pdf";
ATTRIBUTE ALT_SYMBOLS of R11 : label is "RESC0603X35L,RESC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of R11 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R11 : label is "RESISTOR\0201\JUMPER";
ATTRIBUTE \ROHS STATUS\ of R11 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of SW3 : label is "http://www.meder.com/fileadmin/products/en_datasheets/9240000030e.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of SW3 : label is "SW_MK24N";
ATTRIBUTE \PACKING SIZE\ of SW3 : label is "2000";
ATTRIBUTE \MIN OPER TEMP\ of SW3 : label is "-40DEGC";
ATTRIBUTE DESIGN_DATE of SW3 : label is "2009-09-28";
ATTRIBUTE \RTD POWER\ of SW3 : label is "1W";
ATTRIBUTE \PART NUMBER\ of SW3 : label is "08-00137";
ATTRIBUTE DESCRIPTION of SW3 : label is "SWITCH, OTHER, REED SENSOR, SPST-NO, PULL-IN:23AT TO 50AT, 0.3A@60V, 0.3A, 60V, SMD";
ATTRIBUTE MPN of SW3 : label is "MK24-A-3";
ATTRIBUTE FPLIST of SW3 : label is "SW_MK24N,SW_MK24L,SW_MK24M";
ATTRIBUTE CAPACITANCE of SW3 : label is "0.1pF";
ATTRIBUTE MANUFACTURER of SW3 : label is "MEDER";
ATTRIBUTE \MPN STATUS\ of SW3 : label is "ACTIVE";
ATTRIBUTE \PACKING TYPE\ of SW3 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of SW3 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89267";
ATTRIBUTE DESIGNED_BY of SW3 : label is "Agnieszka Barczuk";
ATTRIBUTE REVISION of SW3 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of SW3 : label is "+115DEGC";
ATTRIBUTE \RTD VOLTAGE\ of SW3 : label is "60V";
ATTRIBUTE \RTD CURRENT\ of SW3 : label is "0.3A";
ATTRIBUTE \NOTE STATUS\ of SW3 : label is "PREFERRED";
ATTRIBUTE ALT_SYMBOLS of SW3 : label is "SW_MK24L,SW_MK24M";
ATTRIBUTE \MOUNTING TYPE\ of SW3 : label is "SMD";
ATTRIBUTE \PART TYPE\ of SW3 : label is "SWITCH\OTHER";
ATTRIBUTE \ROHS STATUS\ of SW3 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 2\ of R20 : label is "http://www.vishay.com/docs/20052/crcw0201e3.pdf";
ATTRIBUTE \MTBF STANDARD\ of R20 : label is "CL=90%";
ATTRIBUTE \MAX TC\ of R20 : label is "+200PPM/DEGC";
ATTRIBUTE \MIN TC\ of R20 : label is "-200PPM/DEGC";
ATTRIBUTE \OLD FOOTPRINT\ of R20 : label is "RESC0603X35N,0201";
ATTRIBUTE VOLTAGE of R20 : label is "RVMAX";
ATTRIBUTE MSL of R20 : label is "1";
ATTRIBUTE \PACKING SIZE\ of R20 : label is "10000";
ATTRIBUTE \BUDGET PRICE\ of R20 : label is "N/A";
ATTRIBUTE \LIFECYCLE STATUS\ of R20 : label is "ACTIVE";
ATTRIBUTE \MIN OPER TEMP\ of R20 : label is "-55DEGC";
ATTRIBUTE \RTD POWER\ of R20 : label is "0.05W";
ATTRIBUTE DESCRIPTION of R20 : label is "RESISTOR, THICK FILM, 2K2, -5%/+5%, 0.05W, 30V, -55DEGC/+155DEGC, 0201, SMD";
ATTRIBUTE \PART NUMBER\ of R20 : label is "01-04180";
ATTRIBUTE DIST of R20 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R20 : label is "-5%";
ATTRIBUTE PSPICETEMPLATE of R20 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE MPN of R20 : label is "CRCW02012K20JNED";
ATTRIBUTE \MAX TOL\ of R20 : label is "+5%";
ATTRIBUTE \PCB PACKAGE\ of R20 : label is "0201";
ATTRIBUTE \ESD LEVEL\ of R20 : label is "N/A";
ATTRIBUTE FPLIST of R20 : label is "RESC0603X35N,RESC0603X35L,RESC0603X35M";
ATTRIBUTE WEIGHT of R20 : label is "0.00017g";
ATTRIBUTE \MPN STATUS\ of R20 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of R20 : label is "VISHAY";
ATTRIBUTE \RESISTOR TYPE\ of R20 : label is "THICK FILM";
ATTRIBUTE \AUTODOC FILE\ of R20 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=58987";
ATTRIBUTE \PACKING TYPE\ of R20 : label is "TAPE_&_REEL";
ATTRIBUTE RESISTANCE of R20 : label is "2.2k";
ATTRIBUTE MTBF of R20 : label is "1.00*10^10";
ATTRIBUTE \LEAD TIME\ of R20 : label is "10";
ATTRIBUTE \RTD VOLTAGE\ of R20 : label is "30V";
ATTRIBUTE \MAX OPER TEMP\ of R20 : label is "+155DEGC";
ATTRIBUTE REVISION of R20 : label is "R001";
ATTRIBUTE \NOTE STATUS\ of R20 : label is "PREFERRED";
ATTRIBUTE \DEFINIED QUALITY\ of R20 : label is "INDUSTRIAL";
ATTRIBUTE TC1 of R20 : label is "0";
ATTRIBUTE MAX_TEMP of R20 : label is "RTMAX";
ATTRIBUTE TC2 of R20 : label is "0";
ATTRIBUTE POWER of R20 : label is "RMAX";
ATTRIBUTE \DATASHEET URL 1\ of R20 : label is "N/A";
ATTRIBUTE \ROHS STATUS\ of R20 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of R20 : label is "RESISTOR\0201";
ATTRIBUTE \MOUNTING TYPE\ of R20 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of R20 : label is "RESC0603X35L,RESC0603X35M";
ATTRIBUTE \CLIENT STATUS\ of R21 : label is "UNDER_REVIEW";
ATTRIBUTE \DATASHEET URL 2\ of R21 : label is "N/A";
ATTRIBUTE \MTBF STANDARD\ of R21 : label is "N/A";
ATTRIBUTE \MAX TC\ of R21 : label is "N/A";
ATTRIBUTE \MIN TC\ of R21 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R21 : label is "RESC0603X35N,0201";
ATTRIBUTE VOLTAGE of R21 : label is "RVMAX";
ATTRIBUTE MSL of R21 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of R21 : label is "10000";
ATTRIBUTE \BUDGET CURRENCY\ of R21 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of R21 : label is "0.009";
ATTRIBUTE \LIFECYCLE STATUS\ of R21 : label is "ACTIVE";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R21 : label is "TAIWAN,ISRAEL";
ATTRIBUTE \MIN OPER TEMP\ of R21 : label is "-55DEGC";
ATTRIBUTE \RTD POWER\ of R21 : label is "0.05W";
ATTRIBUTE DESCRIPTION of R21 : label is "RESISTOR, THICK FILM, 0, 0.05W, 30V, -55DEGC/+155DEGC, 0201, SMD";
ATTRIBUTE \PART NUMBER\ of R21 : label is "01-04043";
ATTRIBUTE DIST of R21 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of R21 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of R21 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of R21 : label is "N/A";
ATTRIBUTE PSPICETEMPLATE of R21 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE MPN of R21 : label is "RESISTOR_0201_0_+/-1%_30V_0.05W_M_+/-100ppm";
ATTRIBUTE \MAX TOL\ of R21 : label is "N/A";
ATTRIBUTE \PCB PACKAGE\ of R21 : label is "0201";
ATTRIBUTE \ESD LEVEL\ of R21 : label is "N/A";
ATTRIBUTE WEIGHT of R21 : label is "0.00017g";
ATTRIBUTE \MPN STATUS\ of R21 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of R21 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \RESISTOR TYPE\ of R21 : label is "THICK FILM";
ATTRIBUTE VENDOR of R21 : label is "VISHAY";
ATTRIBUTE \AUTODOC FILE\ of R21 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=58850";
ATTRIBUTE \PACKING TYPE\ of R21 : label is "TAPE_&_REEL";
ATTRIBUTE RESISTANCE of R21 : label is "0";
ATTRIBUTE MTBF of R21 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of R21 : label is "10";
ATTRIBUTE \RTD VOLTAGE\ of R21 : label is "30V";
ATTRIBUTE \MAX OPER TEMP\ of R21 : label is "+155DEGC";
ATTRIBUTE REVISION of R21 : label is "R001";
ATTRIBUTE \RTD CURRENT\ of R21 : label is "N/A";
ATTRIBUTE \LAST TIME BUY\ of R21 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R21 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of R21 : label is "CRCW02010000Z0ED";
ATTRIBUTE \DEFINIED QUALITY\ of R21 : label is "INDUSTRIAL";
ATTRIBUTE TC1 of R21 : label is "0";
ATTRIBUTE MAX_TEMP of R21 : label is "RTMAX";
ATTRIBUTE TC2 of R21 : label is "0";
ATTRIBUTE POWER of R21 : label is "RMAX";
ATTRIBUTE \DATASHEET URL 1\ of R21 : label is "http://www.vishay.com/docs/20052/crcw0201e3.pdf";
ATTRIBUTE \ROHS STATUS\ of R21 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of R21 : label is "RESISTOR\0201\JUMPER";
ATTRIBUTE \MOUNTING TYPE\ of R21 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of R21 : label is "RESC0603X35L,RESC0603X35M";
ATTRIBUTE \CLIENT STATUS\ of R22 : label is "UNDER_REVIEW";
ATTRIBUTE \DATASHEET URL 2\ of R22 : label is "N/A";
ATTRIBUTE \MTBF STANDARD\ of R22 : label is "N/A";
ATTRIBUTE \MAX TC\ of R22 : label is "N/A";
ATTRIBUTE \MIN TC\ of R22 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R22 : label is "RESC0603X35N,0201";
ATTRIBUTE VOLTAGE of R22 : label is "RVMAX";
ATTRIBUTE MSL of R22 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of R22 : label is "10000";
ATTRIBUTE \BUDGET CURRENCY\ of R22 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of R22 : label is "0.009";
ATTRIBUTE \LIFECYCLE STATUS\ of R22 : label is "ACTIVE";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R22 : label is "TAIWAN,ISRAEL";
ATTRIBUTE \MIN OPER TEMP\ of R22 : label is "-55DEGC";
ATTRIBUTE \RTD POWER\ of R22 : label is "0.05W";
ATTRIBUTE DESCRIPTION of R22 : label is "RESISTOR, THICK FILM, 0, 0.05W, 30V, -55DEGC/+155DEGC, 0201, SMD";
ATTRIBUTE \PART NUMBER\ of R22 : label is "01-04043";
ATTRIBUTE DIST of R22 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of R22 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of R22 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of R22 : label is "N/A";
ATTRIBUTE PSPICETEMPLATE of R22 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE MPN of R22 : label is "RESISTOR_0201_0_+/-1%_30V_0.05W_M_+/-100ppm";
ATTRIBUTE \MAX TOL\ of R22 : label is "N/A";
ATTRIBUTE \PCB PACKAGE\ of R22 : label is "0201";
ATTRIBUTE \ESD LEVEL\ of R22 : label is "N/A";
ATTRIBUTE WEIGHT of R22 : label is "0.00017g";
ATTRIBUTE \MPN STATUS\ of R22 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of R22 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \RESISTOR TYPE\ of R22 : label is "THICK FILM";
ATTRIBUTE VENDOR of R22 : label is "VISHAY";
ATTRIBUTE \AUTODOC FILE\ of R22 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=58850";
ATTRIBUTE \PACKING TYPE\ of R22 : label is "TAPE_&_REEL";
ATTRIBUTE RESISTANCE of R22 : label is "0";
ATTRIBUTE MTBF of R22 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of R22 : label is "10";
ATTRIBUTE \RTD VOLTAGE\ of R22 : label is "30V";
ATTRIBUTE \MAX OPER TEMP\ of R22 : label is "+155DEGC";
ATTRIBUTE REVISION of R22 : label is "R001";
ATTRIBUTE \RTD CURRENT\ of R22 : label is "N/A";
ATTRIBUTE \LAST TIME BUY\ of R22 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R22 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of R22 : label is "CRCW02010000Z0ED";
ATTRIBUTE \DEFINIED QUALITY\ of R22 : label is "INDUSTRIAL";
ATTRIBUTE TC1 of R22 : label is "0";
ATTRIBUTE MAX_TEMP of R22 : label is "RTMAX";
ATTRIBUTE TC2 of R22 : label is "0";
ATTRIBUTE POWER of R22 : label is "RMAX";
ATTRIBUTE \DATASHEET URL 1\ of R22 : label is "http://www.vishay.com/docs/20052/crcw0201e3.pdf";
ATTRIBUTE \ROHS STATUS\ of R22 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of R22 : label is "RESISTOR\0201\JUMPER";
ATTRIBUTE \MOUNTING TYPE\ of R22 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of R22 : label is "RESC0603X35L,RESC0603X35M";


-- GATE INSTANCES

BEGIN
\MPU INT\<=N543563;
C21 : \100nF\	PORT MAP(
	\1\ => VDD, 
	\2\ => GND
);
C23 : \100nF\	PORT MAP(
	\1\ => \MIC PWR\, 
	\2\ => GND
);
C24 : \100nF\	PORT MAP(
	\1\ => VDD, 
	\2\ => GND
);
C25 : \100nF\	PORT MAP(
	\1\ => \MPU PWR\, 
	\2\ => GND
);
U3 : BMP280	PORT MAP(
	GND => GND, 
	CSB => VDD, 
	VDDIO => VDD, 
	SDI => SDA, 
	SCK => SCL, 
	SDO => VDD, 
	VDD => VDD
);
C26 : \10nF\	PORT MAP(
	\1\ => \MPU PWR\, 
	\2\ => GND
);
U4 : TMP007	PORT MAP(
	nALERT => \TMP RDY\, 
	SDA => SDA, 
	DGND => GND, 
	AGND => GND, 
	\V+\ => VDD, 
	ADR1 => VDD, 
	SCL => SCL, 
	ADR0 => GND
);
C27 : \100nF\	PORT MAP(
	\1\ => GND, 
	\2\ => N546170
);
C28 : \100nF\	PORT MAP(
	\1\ => VDD, 
	\2\ => GND
);
U5 : HDC1000YPA	PORT MAP(
	GND => GND, 
	SDA => SDA, 
	SCL => SCL, 
	VDD => VDD, 
	ADR0 => VDD, 
	ADR1 => VDD, 
	nDRDY => GND, 
	DNC => GND
);
C29 : \100nF\	PORT MAP(
	\1\ => VDD, 
	\2\ => GND
);
U6 : \SPH0641LM4H-1\	PORT MAP(
	VDD => \MIC PWR\, 
	\SELECT\ => GND, 
	CLOCK => N615347, 
	DATA => N540621, 
	GND => GND
);
U7 : OPT3001	PORT MAP(
	nINT => OPEN, 
	ADDR => VDD, 
	VDD => VDD, 
	GND => GND, 
	\EGP/GND\ => GND, 
	nCLK => SCL, 
	DATA => SDA
);
U8 : \MPU-9250\	PORT MAP(
	NC_6 => OPEN, 
	AUX_DA => 'Z', 
	AUX_CL => 'Z', 
	VDDIO => \MPU PWR\, 
	\AD0/SDO\ => GND, 
	REGOUT => N546170, 
	FSYNC => GND, 
	INT => N543563, 
	VDD => \MPU PWR\, 
	GND => GND, 
	RESV_19 => OPEN, 
	RESV_1 => \MPU PWR\, 
	RESV_20 => GND, 
	nCS => \MPU PWR\, 
	\SCL/SCLK\ => \SCL HP\, 
	\SDA/SDI\ => \SDA HP\, 
	EGP => GND, 
	NC_14 => OPEN, 
	NC_15 => OPEN, 
	NC_16 => OPEN, 
	NC_17 => OPEN, 
	NC_2 => OPEN, 
	NC_3 => OPEN, 
	NC_4 => OPEN, 
	NC_5 => OPEN
);
C31 : \100nF\	PORT MAP(
	\1\ => VDD, 
	\2\ => GND
);
R11 : \0\	PORT MAP(
	\1\ => REED, 
	\2\ => N537485
);
SW3 : \MK24-A\	PORT MAP(
	\2\ => N537485, 
	\1\ => VDD
);
R20 : \2.2k\	PORT MAP(
	\1\ => \TMP RDY\, 
	\2\ => VDD
);
R21 : \0\	PORT MAP(
	\1\ => N615347, 
	\2\ => \DP7/AUDIO CLK\
);
R22 : \0\	PORT MAP(
	\1\ => N540621, 
	\2\ => \AUDIO DI\
);
END STRUCTURE;

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ENTITY \Peripheral and Power\ IS PORT (
	BUTTON1 : OUT std_logic;
	JTAG_TCK : OUT std_logic;
	JTAG_TMS : OUT std_logic;
	BUTTON2 : OUT std_logic;
	nRESET : OUT std_logic;
	SCL : IN std_logic;
	SDA : INOUT std_logic;
	FLASH_CS : IN std_logic;
	LED1 : IN std_logic;
	BUZZER : IN std_logic;
	DP0 : OUT std_logic;
	DP1 : OUT std_logic;
	DP2 : OUT std_logic;
	DP3 : OUT std_logic;
	\DP4/UART_RX\ : OUT std_logic;
	\DP5/UART_TX\ : OUT std_logic;
	\DP6/AUDIO DO\ : OUT std_logic;
	\DP7/AUDIO CLK\ : IN std_logic;
	\DP8/SCLK/TDI\ : OUT std_logic;
	\DP9/MISO\ : OUT std_logic;
	\DP10/MOSI\ : IN std_logic;
	\DP11/CSN\ : IN std_logic;
	\DP12/AUDIO FS/TDO\ : IN std_logic;
	DP_ID : OUT std_logic
); 

END \Peripheral and Power\;



ARCHITECTURE STRUCTURE OF \Peripheral and Power\ IS

-- COMPONENTS

COMPONENT \0\
	PORT (
	\1\ : INOUT std_logic;
	\2\ : INOUT std_logic
	); END COMPONENT;

COMPONENT TPS22910AYZV
	PORT (
	GND : IN std_logic;
	VIN : IN std_logic;
	VOUT : OUT std_logic;
	\ON\ : IN std_logic
	); END COMPONENT;

COMPONENT \BAT+\
	PORT (
	\1\ : IN std_logic
	); END COMPONENT;

COMPONENT \100nF\
	PORT (
	\1\ : INOUT std_logic;
	\2\ : INOUT std_logic
	); END COMPONENT;

COMPONENT \BAT-\
	PORT (
	\1\ : IN std_logic
	); END COMPONENT;

COMPONENT HCS0503B
	PORT (
	\2\ : INOUT std_logic;
	\1\ : INOUT std_logic;
	NC : INOUT std_logic
	); END COMPONENT;

COMPONENT \BAT-HLD-001\
	PORT (
	\+\ : IN std_logic;
	\-\ : IN std_logic
	); END COMPONENT;

COMPONENT \BB02-BS101-KA8-025B00\
	PORT (
	\2\ : INOUT std_logic;
	\4\ : INOUT std_logic;
	\6\ : INOUT std_logic;
	\8\ : INOUT std_logic;
	\10\ : INOUT std_logic;
	\1\ : INOUT std_logic;
	\3\ : INOUT std_logic;
	\5\ : INOUT std_logic;
	\7\ : INOUT std_logic;
	\9\ : INOUT std_logic
	); END COMPONENT;

COMPONENT \LSS-110-01-F-DV-A-TR\
	PORT (
	\1\ : INOUT std_logic;
	\3\ : INOUT std_logic;
	\5\ : INOUT std_logic;
	\7\ : INOUT std_logic;
	\9\ : INOUT std_logic;
	\11\ : INOUT std_logic;
	\13\ : INOUT std_logic;
	\15\ : INOUT std_logic;
	\17\ : INOUT std_logic;
	\19\ : INOUT std_logic;
	\2\ : INOUT std_logic;
	\4\ : INOUT std_logic;
	\6\ : INOUT std_logic;
	\8\ : INOUT std_logic;
	\10\ : INOUT std_logic;
	\12\ : INOUT std_logic;
	\14\ : INOUT std_logic;
	\16\ : INOUT std_logic;
	\18\ : INOUT std_logic;
	\20\ : INOUT std_logic
	); END COMPONENT;

COMPONENT \LS L296-P2Q2-1\
	PORT (
	A : INOUT std_logic;
	C : INOUT std_logic
	); END COMPONENT;

COMPONENT \MTA2-WNC\
	PORT (
	\1\ : INOUT std_logic;
	\2\ : INOUT std_logic
	); END COMPONENT;

COMPONENT BC846B
	PORT (
	BASE : INOUT std_logic;
	COLLECTOR : INOUT std_logic;
	EMITTER : INOUT std_logic
	); END COMPONENT;

COMPONENT MX25R8035FZUIL0
	PORT (
	nCS : IN std_logic;
	\SO/SIO1\ : INOUT std_logic;
	\nWP/SIO2\ : INOUT std_logic;
	GND : IN std_logic;
	\SI/SIO0\ : INOUT std_logic;
	SCLK : IN std_logic;
	\nRST/SIO3\ : INOUT std_logic;
	VCC : IN std_logic;
	EGP : IN std_logic
	); END COMPONENT;

-- SIGNALS

SIGNAL \DEVPACK->VDD\ : std_logic;
SIGNAL N591139 : std_logic;
SIGNAL N591143 : std_logic;
SIGNAL GND : std_logic;
SIGNAL N256047 : std_logic;
SIGNAL N553359 : std_logic;
SIGNAL N553749 : std_logic;
SIGNAL N553802 : std_logic;
SIGNAL N567147 : std_logic;
SIGNAL N593616 : std_logic;
SIGNAL N593675 : std_logic;
SIGNAL N620089 : std_logic;
SIGNAL \POWER GOOD\ : std_logic;
SIGNAL VDD : std_logic;
SIGNAL VDD_BATT : std_logic;

-- INSTANCE ATTRIBUTES

ATTRIBUTE \MAX TC\:string;
ATTRIBUTE \MAX TC\ of R26 : label is "N/A";
ATTRIBUTE \MTBF STANDARD\:string;
ATTRIBUTE \MTBF STANDARD\ of R26 : label is "N/A";
ATTRIBUTE \DATASHEET URL 2\:string;
ATTRIBUTE \DATASHEET URL 2\ of R26 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\:string;
ATTRIBUTE \CLIENT STATUS\ of R26 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\:string;
ATTRIBUTE \OLD FOOTPRINT\ of R26 : label is "RESC1005X40N";
ATTRIBUTE \MIN TC\:string;
ATTRIBUTE \MIN TC\ of R26 : label is "N/A";
ATTRIBUTE VOLTAGE:string;
ATTRIBUTE VOLTAGE of R26 : label is "RVMAX";
ATTRIBUTE \LIFECYCLE STATUS\:string;
ATTRIBUTE \LIFECYCLE STATUS\ of R26 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\:string;
ATTRIBUTE \BUDGET PRICE\ of R26 : label is "0.007";
ATTRIBUTE \BUDGET CURRENCY\:string;
ATTRIBUTE \BUDGET CURRENCY\ of R26 : label is "EUR";
ATTRIBUTE \PACKING SIZE\:string;
ATTRIBUTE \PACKING SIZE\ of R26 : label is "10000";
ATTRIBUTE MSL:string;
ATTRIBUTE MSL of R26 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\:string;
ATTRIBUTE \MIN OPER TEMP\ of R26 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\:string;
ATTRIBUTE \COUNTRY OF ORIGIN\ of R26 : label is "ISRAEL";
ATTRIBUTE \RTD POWER\:string;
ATTRIBUTE \RTD POWER\ of R26 : label is "0.063W";
ATTRIBUTE \PART NUMBER\:string;
ATTRIBUTE \PART NUMBER\ of R26 : label is "01-16938";
ATTRIBUTE DESCRIPTION:string;
ATTRIBUTE DESCRIPTION of R26 : label is "RESISTOR, THICK FILM, 0, 0.063W, 50V, -55DEGC/+155DEGC, 0402, SMD";
ATTRIBUTE DIST:string;
ATTRIBUTE DIST of R26 : label is "FLAT";
ATTRIBUTE \MIN TOL\:string;
ATTRIBUTE \MIN TOL\ of R26 : label is "N/A";
ATTRIBUTE \BU NAME\:string;
ATTRIBUTE \BU NAME\ of R26 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\:string;
ATTRIBUTE \VENDOR PART STATUS\ of R26 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE:string;
ATTRIBUTE PSPICETEMPLATE of R26 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\:string;
ATTRIBUTE \PCB PACKAGE\ of R26 : label is "0402";
ATTRIBUTE \MAX TOL\:string;
ATTRIBUTE \MAX TOL\ of R26 : label is "N/A";
ATTRIBUTE MPN:string;
ATTRIBUTE MPN of R26 : label is "RESISTOR_0402_0_+/-5%_50V_0.063W_M_+/-200PPM";
ATTRIBUTE \ESD LEVEL\:string;
ATTRIBUTE \ESD LEVEL\ of R26 : label is "N/A";
ATTRIBUTE \RESISTOR TYPE\:string;
ATTRIBUTE \RESISTOR TYPE\ of R26 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER:string;
ATTRIBUTE MANUFACTURER of R26 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\:string;
ATTRIBUTE \MPN STATUS\ of R26 : label is "ACTIVE";
ATTRIBUTE WEIGHT:string;
ATTRIBUTE WEIGHT of R26 : label is "0.0006152g";
ATTRIBUTE RESISTANCE:string;
ATTRIBUTE RESISTANCE of R26 : label is "0";
ATTRIBUTE \PACKING TYPE\:string;
ATTRIBUTE \PACKING TYPE\ of R26 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\:string;
ATTRIBUTE \AUTODOC FILE\ of R26 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=86391";
ATTRIBUTE VENDOR:string;
ATTRIBUTE VENDOR of R26 : label is "VISHAY";
ATTRIBUTE \LEAD TIME\:string;
ATTRIBUTE \LEAD TIME\ of R26 : label is "14";
ATTRIBUTE MTBF:string;
ATTRIBUTE MTBF of R26 : label is "N/A";
ATTRIBUTE REVISION:string;
ATTRIBUTE REVISION of R26 : label is "R007";
ATTRIBUTE \MAX OPER TEMP\:string;
ATTRIBUTE \MAX OPER TEMP\ of R26 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\:string;
ATTRIBUTE \RTD VOLTAGE\ of R26 : label is "50V";
ATTRIBUTE \NOTE STATUS\:string;
ATTRIBUTE \NOTE STATUS\ of R26 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\:string;
ATTRIBUTE \LAST TIME BUY\ of R26 : label is "N/A";
ATTRIBUTE \RTD CURRENT\:string;
ATTRIBUTE \RTD CURRENT\ of R26 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\:string;
ATTRIBUTE \DEFINIED QUALITY\ of R26 : label is "INDUSTRIAL";
ATTRIBUTE \VENDOR PART NUMBER\:string;
ATTRIBUTE \VENDOR PART NUMBER\ of R26 : label is "CRCW04020000Z0ED";
ATTRIBUTE TC1:string;
ATTRIBUTE TC1 of R26 : label is "0";
ATTRIBUTE MAX_TEMP:string;
ATTRIBUTE MAX_TEMP of R26 : label is "RTMAX";
ATTRIBUTE TC2:string;
ATTRIBUTE TC2 of R26 : label is "0";
ATTRIBUTE POWER:string;
ATTRIBUTE POWER of R26 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS:string;
ATTRIBUTE ALT_SYMBOLS of R26 : label is "RESC1005X40A2L,RESC1005X40A2M";
ATTRIBUTE \MOUNTING TYPE\:string;
ATTRIBUTE \MOUNTING TYPE\ of R26 : label is "SMD";
ATTRIBUTE \PART TYPE\:string;
ATTRIBUTE \PART TYPE\ of R26 : label is "RESISTOR\0402\JUMPER";
ATTRIBUTE \ROHS STATUS\:string;
ATTRIBUTE \ROHS STATUS\ of R26 : label is "ROHS_COMPLIANT_WITH_EXEMPTION";
ATTRIBUTE \DATASHEET URL 1\:string;
ATTRIBUTE \DATASHEET URL 1\ of R26 : label is "http://www.vishay.com/docs/20035/dcrcwe3.pdf";
ATTRIBUTE \MAX TC\ of R28 : label is "+200PPM/DEGC";
ATTRIBUTE \DATASHEET URL 2\ of R28 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R28 : label is "RESC0603X35N,0201";
ATTRIBUTE \MIN TC\ of R28 : label is "-200PPM/DEGC";
ATTRIBUTE VOLTAGE of R28 : label is "RVMAX";
ATTRIBUTE \LIFECYCLE STATUS\ of R28 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of R28 : label is "0.0041";
ATTRIBUTE \BUDGET CURRENCY\ of R28 : label is "USD";
ATTRIBUTE \PACKING SIZE\ of R28 : label is "10000";
ATTRIBUTE \MIN OPER TEMP\ of R28 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R28 : label is "TAIWAN";
ATTRIBUTE \RTD POWER\ of R28 : label is "0.05W";
ATTRIBUTE \PART NUMBER\ of R28 : label is "01-04220";
ATTRIBUTE DESCRIPTION of R28 : label is "RESISTOR, THICK FILM, 100k, -5%/+5%, 0.05W, 30V, -55DEGC/+155DEGC, 0201, SMD";
ATTRIBUTE DIST of R28 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R28 : label is "-5%";
ATTRIBUTE \BU NAME\ of R28 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R28 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R28 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R28 : label is "0201";
ATTRIBUTE \MAX TOL\ of R28 : label is "+5%";
ATTRIBUTE MPN of R28 : label is "RESISTOR_0201_100k_+/-5%_30V_0.05W_M_+/-200ppm";
ATTRIBUTE \RESISTOR TYPE\ of R28 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER of R28 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of R28 : label is "ACTIVE";
ATTRIBUTE WEIGHT of R28 : label is "0.00017g";
ATTRIBUTE RESISTANCE of R28 : label is "100k";
ATTRIBUTE \AUTODOC FILE\ of R28 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=59027";
ATTRIBUTE VENDOR of R28 : label is "VISHAY";
ATTRIBUTE \PACKING TYPE\ of R28 : label is "TAPE_&_REEL";
ATTRIBUTE \LEAD TIME\ of R28 : label is "7 ";
ATTRIBUTE REVISION of R28 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of R28 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\ of R28 : label is "30V";
ATTRIBUTE \RTD CURRENT\ of R28 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R28 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of R28 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of R28 : label is "MILITARY";
ATTRIBUTE \VENDOR PART NUMBER\ of R28 : label is "CRCW0201100KJNED";
ATTRIBUTE TC1 of R28 : label is "0";
ATTRIBUTE MAX_TEMP of R28 : label is "RTMAX";
ATTRIBUTE TC2 of R28 : label is "0";
ATTRIBUTE POWER of R28 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS of R28 : label is "RESC0603X35L,RESC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of R28 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R28 : label is "RESISTOR\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of R28 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of R28 : label is "http://www.vishay.com/docs/20052/crcw0201e3.pdf";
ATTRIBUTE \DATASHEET URL 2\ of U2 : label is "http://www.ti.com/lit/ds/symlink/tps22910a.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of U2 : label is "BGAFC4C50P89X89X50";
ATTRIBUTE MSL of U2 : label is "1";
ATTRIBUTE \PACKING SIZE\ of U2 : label is "3000";
ATTRIBUTE \BUDGET CURRENCY\ of U2 : label is "USD";
ATTRIBUTE \BUDGET PRICE\ of U2 : label is "0.24";
ATTRIBUTE \LIFECYCLE STATUS\ of U2 : label is "ACTIVE";
ATTRIBUTE \MIN OPER TEMP\ of U2 : label is "-40DEGC";
ATTRIBUTE DESIGN_DATE:string;
ATTRIBUTE DESIGN_DATE of U2 : label is "2014-10-27";
ATTRIBUTE CLASS:string;
ATTRIBUTE CLASS of U2 : label is "IC";
ATTRIBUTE DESCRIPTION of U2 : label is "IC, ANALOG, LOW ON-RESISTANCE LOAD SWITCH WITH CONTROLLED TURN-ON, ENABLE:ACTIVE LOW, 1.4V TO 5.5V, DSBGA4, SMD";
ATTRIBUTE \PART NUMBER\ of U2 : label is "18-29653";
ATTRIBUTE MPN of U2 : label is "TPS22910AYZVR";
ATTRIBUTE \PCB PACKAGE\ of U2 : label is "DSBGA4";
ATTRIBUTE WEIGHT of U2 : label is "0.001029761g";
ATTRIBUTE \MPN STATUS\ of U2 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of U2 : label is "TEXAS INSTRUMENTS";
ATTRIBUTE \AUTODOC FILE\ of U2 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=97180";
ATTRIBUTE \PACKING TYPE\ of U2 : label is "TAPE_&_REEL";
ATTRIBUTE DESIGNED_BY:string;
ATTRIBUTE DESIGNED_BY of U2 : label is "Artur Bielinski";
ATTRIBUTE \RTD VOLTAGE\ of U2 : label is "1.4V TO 5.5V";
ATTRIBUTE \MAX OPER TEMP\ of U2 : label is "+85DEGC";
ATTRIBUTE REVISION of U2 : label is "R001";
ATTRIBUTE \NOTE STATUS\ of U2 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of U2 : label is "2A";
ATTRIBUTE \DATASHEET URL 1\ of U2 : label is "http://www.ti.com/litv/pdf/mxbg052b";
ATTRIBUTE \ROHS STATUS\ of U2 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of U2 : label is "IC\ANALOG\PM\SWITCH";
ATTRIBUTE \MOUNTING TYPE\ of U2 : label is "SMD";
ATTRIBUTE \OLD FOOTPRINT\ of \BAT+\ : label is "PAD_S2000OBL3600_1000M3000";
ATTRIBUTE \PART NUMBER\ of \BAT+\ : label is "19-00356";
ATTRIBUTE DESCRIPTION of \BAT+\ : label is "NON COMPONENT, BATTERY + PAD, SMD";
ATTRIBUTE \AUTODOC FILE\ of \BAT+\ : label is "https://notefied-dynamic-precision.com/NotefiedWebServices/AutoDocs.aspx?itemid=87841";
ATTRIBUTE REVISION of \BAT+\ : label is "R001";
ATTRIBUTE \PART TYPE\ of \BAT+\ : label is "NON_COMPONENT\PAD";
ATTRIBUTE \DATASHEET URL 2\ of C28 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C28 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C28 : label is "CAPC0603X35N";
ATTRIBUTE \PACKING SIZE\ of C28 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of C28 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of C28 : label is "0.008";
ATTRIBUTE CURRENT:string;
ATTRIBUTE CURRENT of C28 : label is "CIMAX";
ATTRIBUTE KNEE:string;
ATTRIBUTE KNEE of C28 : label is "CBMAX";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C28 : label is "MISSING INFO";
ATTRIBUTE \MIN OPER TEMP\ of C28 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C28 : label is "02-06085";
ATTRIBUTE DESCRIPTION of C28 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE DIST of C28 : label is "FLAT";
ATTRIBUTE \VENDOR PART STATUS\ of C28 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of C28 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \MIN TOL\ of C28 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C28 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE:string;
ATTRIBUTE SLOPE of C28 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C28 : label is "0201";
ATTRIBUTE \MAX TOL\ of C28 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\:string;
ATTRIBUTE \DIELECTRIC TYPE\ of C28 : label is "X5R";
ATTRIBUTE MPN of C28 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE CAPACITANCE:string;
ATTRIBUTE CAPACITANCE of C28 : label is "100nF";
ATTRIBUTE MANUFACTURER of C28 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of C28 : label is "ACTIVE";
ATTRIBUTE WEIGHT of C28 : label is "0.00033g";
ATTRIBUTE \PACKING TYPE\ of C28 : label is "TAPE_&_REEL";
ATTRIBUTE VENDOR of C28 : label is "MURATA";
ATTRIBUTE \AUTODOC FILE\ of C28 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE \LEAD TIME\ of C28 : label is "17";
ATTRIBUTE REVISION of C28 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of C28 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C28 : label is "10V";
ATTRIBUTE \LAST TIME BUY\ of C28 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of C28 : label is "PREFERRED";
ATTRIBUTE \VENDOR PART NUMBER\ of C28 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C28 : label is "CTMAX";
ATTRIBUTE TC1 of C28 : label is "0";
ATTRIBUTE TC2 of C28 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C28 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE ALT_SYMBOLS of C28 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of C28 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C28 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of C28 : label is "ROHS_COMPLIANT";
ATTRIBUTE \MAX TC\ of R33 : label is "+200PPM/DEGC";
ATTRIBUTE \MTBF STANDARD\ of R33 : label is "CL=90%";
ATTRIBUTE \DATASHEET URL 2\ of R33 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R33 : label is "RESC0603X35N,0201";
ATTRIBUTE \MIN TC\ of R33 : label is "-200PPM/DEGC";
ATTRIBUTE VOLTAGE of R33 : label is "RVMAX";
ATTRIBUTE \LIFECYCLE STATUS\ of R33 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of R33 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of R33 : label is "10000";
ATTRIBUTE MSL of R33 : label is "1";
ATTRIBUTE \MIN OPER TEMP\ of R33 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R33 : label is "TAIWAN";
ATTRIBUTE \RTD POWER\ of R33 : label is "0.05W";
ATTRIBUTE \PART NUMBER\ of R33 : label is "01-04180";
ATTRIBUTE DESCRIPTION of R33 : label is "RESISTOR, THICK FILM, 2.2k, -5%/+5%, 0.05W, 30V, -55DEGC/+155DEGC, 0201, SMD";
ATTRIBUTE DIST of R33 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R33 : label is "-5%";
ATTRIBUTE \BU NAME\ of R33 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R33 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R33 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R33 : label is "0201";
ATTRIBUTE \MAX TOL\ of R33 : label is "+5%";
ATTRIBUTE MPN of R33 : label is "CRCW02012K20JNED";
ATTRIBUTE \RESISTOR TYPE\ of R33 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER of R33 : label is "VISHAY";
ATTRIBUTE \MPN STATUS\ of R33 : label is "ACTIVE";
ATTRIBUTE WEIGHT of R33 : label is "0.00017g";
ATTRIBUTE RESISTANCE of R33 : label is "2.2k";
ATTRIBUTE \PACKING TYPE\ of R33 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of R33 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=58987";
ATTRIBUTE VENDOR of R33 : label is "VISHAY";
ATTRIBUTE \LEAD TIME\ of R33 : label is "10";
ATTRIBUTE MTBF of R33 : label is "1.00*10^10";
ATTRIBUTE REVISION of R33 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of R33 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\ of R33 : label is "30V";
ATTRIBUTE \NOTE STATUS\ of R33 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of R33 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of R33 : label is "COMMERCIAL";
ATTRIBUTE \VENDOR PART NUMBER\ of R33 : label is "CRCW02012K20JNED";
ATTRIBUTE TC1 of R33 : label is "0";
ATTRIBUTE MAX_TEMP of R33 : label is "RTMAX";
ATTRIBUTE TC2 of R33 : label is "0";
ATTRIBUTE POWER of R33 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS of R33 : label is "RESC0603X35L,RESC0603X35M";
ATTRIBUTE \MOUNTING TYPE\ of R33 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R33 : label is "RESISTOR\0201\STANDARD";
ATTRIBUTE \ROHS STATUS\ of R33 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of R33 : label is "http://www.vishay.com/docs/20052/crcw0201e3.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of \BAT-\ : label is "PAD_S2000OBL3600_1000M3000";
ATTRIBUTE DESCRIPTION of \BAT-\ : label is "NON COMPONENT, BATTERY - PAD, SMD";
ATTRIBUTE \PART NUMBER\ of \BAT-\ : label is "19-00357";
ATTRIBUTE \AUTODOC FILE\ of \BAT-\ : label is "https://notefied-dynamic-precision.com/NotefiedWebServices/AutoDocs.aspx?itemid=87842";
ATTRIBUTE REVISION of \BAT-\ : label is "R001";
ATTRIBUTE \PART TYPE\ of \BAT-\ : label is "NON_COMPONENT\PAD";
ATTRIBUTE \DATASHEET URL 2\ of R7 : label is "N/A";
ATTRIBUTE \MAX TC\ of R7 : label is "+200PPM/DEGC";
ATTRIBUTE \MIN TC\ of R7 : label is "-200PPM/DEGC";
ATTRIBUTE \OLD FOOTPRINT\ of R7 : label is "RESC0603X35N,0201";
ATTRIBUTE VOLTAGE of R7 : label is "RVMAX";
ATTRIBUTE \BUDGET PRICE\ of R7 : label is "0.0041";
ATTRIBUTE \BUDGET CURRENCY\ of R7 : label is "USD";
ATTRIBUTE \PACKING SIZE\ of R7 : label is "10000";
ATTRIBUTE \MIN OPER TEMP\ of R7 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R7 : label is "TAIWAN";
ATTRIBUTE \RTD POWER\ of R7 : label is "0.05W";
ATTRIBUTE DESCRIPTION of R7 : label is "RESISTOR, THICK FILM, 10k, -5%/+5%, 0.05W, 30V, -55DEGC/+155DEGC, 0201, SMD";
ATTRIBUTE \PART NUMBER\ of R7 : label is "01-04196";
ATTRIBUTE DIST of R7 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R7 : label is "-5%";
ATTRIBUTE \BU NAME\ of R7 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R7 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R7 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE MPN of R7 : label is "RESISTOR_0201_10k_+/-5%_30V_0.05W_M_+/-200ppm";
ATTRIBUTE \MAX TOL\ of R7 : label is "+5%";
ATTRIBUTE \PCB PACKAGE\ of R7 : label is "0201";
ATTRIBUTE \MPN STATUS\ of R7 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of R7 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \RESISTOR TYPE\ of R7 : label is "THICK FILM";
ATTRIBUTE WEIGHT of R7 : label is "0.00017g";
ATTRIBUTE \AUTODOC FILE\ of R7 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=59003";
ATTRIBUTE RESISTANCE of R7 : label is "10k";
ATTRIBUTE VENDOR of R7 : label is "VISHAY";
ATTRIBUTE \PACKING TYPE\ of R7 : label is "TAPE_&_REEL";
ATTRIBUTE \LEAD TIME\ of R7 : label is "7 ";
ATTRIBUTE \RTD VOLTAGE\ of R7 : label is "30V";
ATTRIBUTE \MAX OPER TEMP\ of R7 : label is "+155DEGC";
ATTRIBUTE REVISION of R7 : label is "R001";
ATTRIBUTE \NOTE STATUS\ of R7 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of R7 : label is "N/A";
ATTRIBUTE \LAST TIME BUY\ of R7 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of R7 : label is "INDUSTRIAL";
ATTRIBUTE \VENDOR PART NUMBER\ of R7 : label is "CRCW020110K0JNED";
ATTRIBUTE TC1 of R7 : label is "0";
ATTRIBUTE MAX_TEMP of R7 : label is "RTMAX";
ATTRIBUTE TC2 of R7 : label is "0";
ATTRIBUTE POWER of R7 : label is "RMAX";
ATTRIBUTE \DATASHEET URL 1\ of R7 : label is "http://www.vishay.com/docs/20052/crcw0201e3.pdf";
ATTRIBUTE \ROHS STATUS\ of R7 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of R7 : label is "RESISTOR\0201\STANDARD";
ATTRIBUTE \MOUNTING TYPE\ of R7 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of R7 : label is "RESC0603X35L,RESC0603X35M";
ATTRIBUTE \DATASHEET URL 2\ of R8 : label is "http://www.kamaya.co.jp/pdf_en/catalog-rmc.pdf";
ATTRIBUTE \MTBF STANDARD\ of R8 : label is "N/A";
ATTRIBUTE \MAX TC\ of R8 : label is "+600PPM/DEGC";
ATTRIBUTE \MIN TC\ of R8 : label is "-200PPM/DEGC";
ATTRIBUTE \OLD FOOTPRINT\ of R8 : label is "RESC0603X35N,0201";
ATTRIBUTE VOLTAGE of R8 : label is "RVMAX";
ATTRIBUTE MSL of R8 : label is "1";
ATTRIBUTE \PACKING SIZE\ of R8 : label is "15000";
ATTRIBUTE \BUDGET CURRENCY\ of R8 : label is "N/A";
ATTRIBUTE \BUDGET PRICE\ of R8 : label is "N/A";
ATTRIBUTE \LIFECYCLE STATUS\ of R8 : label is "ACTIVE";
ATTRIBUTE \MIN OPER TEMP\ of R8 : label is "-55DEGC";
ATTRIBUTE \RTD POWER\ of R8 : label is "0.05W";
ATTRIBUTE DESCRIPTION of R8 : label is "RESISTOR, THICK FILM, 5R1, -5%/+5%, 0.05W, 25V, -55DEGC/+125DEGC, 0201, SMD";
ATTRIBUTE \PART NUMBER\ of R8 : label is "01-00444";
ATTRIBUTE DIST of R8 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R8 : label is "-5%";
ATTRIBUTE PSPICETEMPLATE of R8 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE MPN of R8 : label is "RMC1/205R1JPA";
ATTRIBUTE \MAX TOL\ of R8 : label is "+5%";
ATTRIBUTE \PCB PACKAGE\ of R8 : label is "0201";
ATTRIBUTE \ESD LEVEL\ of R8 : label is "N/A";
ATTRIBUTE FPLIST:string;
ATTRIBUTE FPLIST of R8 : label is "RESC0603X35N,RESC0603X35L,RESC0603X35M";
ATTRIBUTE WEIGHT of R8 : label is "0.00016g";
ATTRIBUTE \MPN STATUS\ of R8 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of R8 : label is "KAMAYA";
ATTRIBUTE \RESISTOR TYPE\ of R8 : label is "THICK FILM";
ATTRIBUTE \AUTODOC FILE\ of R8 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=46328";
ATTRIBUTE \PACKING TYPE\ of R8 : label is "TAPE_&_REEL";
ATTRIBUTE RESISTANCE of R8 : label is "5.1";
ATTRIBUTE MTBF of R8 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of R8 : label is "N/A";
ATTRIBUTE \RTD VOLTAGE\ of R8 : label is "25V";
ATTRIBUTE \MAX OPER TEMP\ of R8 : label is "+125DEGC";
ATTRIBUTE REVISION of R8 : label is "R001";
ATTRIBUTE \LAST TIME BUY\ of R8 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R8 : label is "PREFERRED";
ATTRIBUTE \DEFINIED QUALITY\ of R8 : label is "INDUSTRIAL";
ATTRIBUTE TC1 of R8 : label is "0";
ATTRIBUTE MAX_TEMP of R8 : label is "RTMAX";
ATTRIBUTE TC2 of R8 : label is "0";
ATTRIBUTE POWER of R8 : label is "RMAX";
ATTRIBUTE \DATASHEET URL 1\ of R8 : label is "N/A";
ATTRIBUTE \ROHS STATUS\ of R8 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of R8 : label is "RESISTOR\0201";
ATTRIBUTE \MOUNTING TYPE\ of R8 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of R8 : label is "RESC0603X35L,RESC0603X35M";
ATTRIBUTE \MAX TC\ of R9 : label is "N/A";
ATTRIBUTE \MTBF STANDARD\ of R9 : label is "N/A";
ATTRIBUTE \DATASHEET URL 2\ of R9 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of R9 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of R9 : label is "RESC1005X40N";
ATTRIBUTE \MIN TC\ of R9 : label is "N/A";
ATTRIBUTE VOLTAGE of R9 : label is "RVMAX";
ATTRIBUTE \LIFECYCLE STATUS\ of R9 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of R9 : label is "0.007";
ATTRIBUTE \BUDGET CURRENCY\ of R9 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of R9 : label is "10000";
ATTRIBUTE MSL of R9 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\ of R9 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R9 : label is "ISRAEL";
ATTRIBUTE \RTD POWER\ of R9 : label is "0.063W";
ATTRIBUTE \PART NUMBER\ of R9 : label is "01-16938";
ATTRIBUTE DESCRIPTION of R9 : label is "RESISTOR, THICK FILM, 0, 0.063W, 50V, -55DEGC/+155DEGC, 0402, SMD";
ATTRIBUTE DIST of R9 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R9 : label is "N/A";
ATTRIBUTE \BU NAME\ of R9 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R9 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R9 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R9 : label is "0402";
ATTRIBUTE \MAX TOL\ of R9 : label is "N/A";
ATTRIBUTE MPN of R9 : label is "RESISTOR_0402_0_+/-5%_50V_0.063W_M_+/-200ppm";
ATTRIBUTE \ESD LEVEL\ of R9 : label is "N/A";
ATTRIBUTE \RESISTOR TYPE\ of R9 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER of R9 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of R9 : label is "ACTIVE";
ATTRIBUTE WEIGHT of R9 : label is "0.0006152g";
ATTRIBUTE RESISTANCE of R9 : label is "0";
ATTRIBUTE \PACKING TYPE\ of R9 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of R9 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=86391";
ATTRIBUTE VENDOR of R9 : label is "VISHAY";
ATTRIBUTE \LEAD TIME\ of R9 : label is "14";
ATTRIBUTE MTBF of R9 : label is "N/A";
ATTRIBUTE REVISION of R9 : label is "R007";
ATTRIBUTE \MAX OPER TEMP\ of R9 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\ of R9 : label is "50V";
ATTRIBUTE \RTD CURRENT\ of R9 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R9 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of R9 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of R9 : label is "INDUSTRIAL";
ATTRIBUTE \VENDOR PART NUMBER\ of R9 : label is "CRCW04020000Z0ED";
ATTRIBUTE TC1 of R9 : label is "0";
ATTRIBUTE MAX_TEMP of R9 : label is "RTMAX";
ATTRIBUTE TC2 of R9 : label is "0";
ATTRIBUTE POWER of R9 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS of R9 : label is "RESC1005X40A2L,RESC1005X40A2M";
ATTRIBUTE \MOUNTING TYPE\ of R9 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R9 : label is "RESISTOR\0402\JUMPER";
ATTRIBUTE \ROHS STATUS\ of R9 : label is "ROHS_COMPLIANT_WITH_EXEMPTION";
ATTRIBUTE \DATASHEET URL 1\ of R9 : label is "http://www.vishay.com/docs/20035/dcrcwe3.pdf";
ATTRIBUTE \DATASHEET URL 2\ of BZ1 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of BZ1 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of BZ1 : label is "BUZ_HCS0503BN";
ATTRIBUTE \BUDGET PRICE\ of BZ1 : label is "N/A";
ATTRIBUTE \BUDGET CURRENCY\ of BZ1 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of BZ1 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\ of BZ1 : label is "-40DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of BZ1 : label is "CHINA";
ATTRIBUTE \PART NUMBER\ of BZ1 : label is "11-00010";
ATTRIBUTE DESCRIPTION of BZ1 : label is "ACOUSTIC, BUZZER, 3V, SMD";
ATTRIBUTE \BU NAME\ of BZ1 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of BZ1 : label is "ACTIVE";
ATTRIBUTE MPN of BZ1 : label is "HCS0503B";
ATTRIBUTE MANUFACTURER of BZ1 : label is "CHANGZHOU TIANYIN";
ATTRIBUTE \MPN STATUS\ of BZ1 : label is "ACTIVE";
ATTRIBUTE WEIGHT of BZ1 : label is "0.3g";
ATTRIBUTE RESISTANCE of BZ1 : label is "12";
ATTRIBUTE \AUTODOC FILE\ of BZ1 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89293";
ATTRIBUTE VENDOR of BZ1 : label is "CHANGZHOU TIANYIN";
ATTRIBUTE \PACKING TYPE\ of BZ1 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of BZ1 : label is "N/A";
ATTRIBUTE REVISION of BZ1 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of BZ1 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of BZ1 : label is "3V";
ATTRIBUTE \RTD CURRENT\ of BZ1 : label is "0.08A";
ATTRIBUTE \NOTE STATUS\ of BZ1 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of BZ1 : label is "N/A";
ATTRIBUTE \VENDOR PART NUMBER\ of BZ1 : label is "HCS0503B";
ATTRIBUTE ALT_SYMBOLS of BZ1 : label is "BUZ_HCS0503BL,BUZ_HCS0503BM";
ATTRIBUTE \MOUNTING TYPE\ of BZ1 : label is "SMD";
ATTRIBUTE \PART TYPE\ of BZ1 : label is "ACOUSTIC\BUZZER";
ATTRIBUTE FREQUENCY:string;
ATTRIBUTE FREQUENCY of BZ1 : label is "4kHz";
ATTRIBUTE \ROHS STATUS\ of BZ1 : label is "MISSING_INFO";
ATTRIBUTE \DATASHEET URL 1\ of BZ1 : label is "http://www.tycz.com/english/products.asp?Action=Detail&ID=155";
ATTRIBUTE \DATASHEET URL 2\ of BT1 : label is "http://www.linxtechnologies.com/resources/documents/battery_holder_overview_guide.pdf";
ATTRIBUTE \CLIENT STATUS\ of BT1 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of BT1 : label is "BAT_BATHLD001N,BAT_BATHLD001AN";
ATTRIBUTE \BUDGET PRICE\ of BT1 : label is "0.65";
ATTRIBUTE \BUDGET CURRENCY\ of BT1 : label is "USD";
ATTRIBUTE \PACKING SIZE\ of BT1 : label is "100";
ATTRIBUTE \MIN OPER TEMP\ of BT1 : label is "N/A";
ATTRIBUTE \COUNTRY OF ORIGIN\ of BT1 : label is "MISSING INFO";
ATTRIBUTE \PART NUMBER\ of BT1 : label is "10-00027";
ATTRIBUTE DESCRIPTION of BT1 : label is "BATTERY, HOLDER, CR2032 AND CR2025 BATTERIES, SMD";
ATTRIBUTE \BU NAME\ of BT1 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of BT1 : label is "ACTIVE";
ATTRIBUTE MPN of BT1 : label is "BAT-HLD-001";
ATTRIBUTE FPLIST of BT1 : label is "BAT_BATHLD001N,BAT_BATHLD001AN";
ATTRIBUTE MANUFACTURER of BT1 : label is "LINX";
ATTRIBUTE \MPN STATUS\ of BT1 : label is "ACTIVE";
ATTRIBUTE WEIGHT of BT1 : label is "N/A";
ATTRIBUTE \PACKING TYPE\ of BT1 : label is "BULK";
ATTRIBUTE \AUTODOC FILE\ of BT1 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=90654";
ATTRIBUTE VENDOR of BT1 : label is "LINX";
ATTRIBUTE \LEAD TIME\ of BT1 : label is "N/A";
ATTRIBUTE REVISION of BT1 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of BT1 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of BT1 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of BT1 : label is "N/A";
ATTRIBUTE \VENDOR PART NUMBER\ of BT1 : label is "BAT-HLD-001";
ATTRIBUTE ALT_SYMBOLS of BT1 : label is "BAT_BATHLD001L,BAT_BATHLD001M,BAT_BATHLD001AL,BAT_BATHLD001AM";
ATTRIBUTE \MOUNTING TYPE\ of BT1 : label is "SMD";
ATTRIBUTE \PART TYPE\ of BT1 : label is "BATTERY\HOLDER";
ATTRIBUTE \ROHS STATUS\ of BT1 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of BT1 : label is "http://www.linxtechnologies.com/resources/diagrams/bat-hld-001.pdf";
ATTRIBUTE \MTBF STANDARD\ of P1 : label is "N/A";
ATTRIBUTE \DATASHEET URL 2\ of P1 : label is "http://www.gradconn.com/1-27mm/pdf/BB02-BS.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of P1 : label is "GRADCON_BB02BS101KA8025B00N";
ATTRIBUTE MSL of P1 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of P1 : label is "N/A";
ATTRIBUTE \BUDGET CURRENCY\ of P1 : label is "N/A";
ATTRIBUTE \BUDGET PRICE\ of P1 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\ of P1 : label is "-40DEGC";
ATTRIBUTE \NO OF POS\:string;
ATTRIBUTE \NO OF POS\ of P1 : label is "10";
ATTRIBUTE DESCRIPTION of P1 : label is "CONNECTOR, HEADER, MALE, 2 ROWS, 10 PINS, PITCH 1.27mm, SMD";
ATTRIBUTE \PART NUMBER\ of P1 : label is "06-03298";
ATTRIBUTE MPN of P1 : label is "BB02-BS101-KA8-025B00";
ATTRIBUTE \ESD LEVEL\ of P1 : label is "N/A";
ATTRIBUTE FPLIST of P1 : label is "GRADCON_BB02BS101KA8025B00N,GRADCON_BB02BS101KA8025B00L,GRADCON_BB02BS101KA8025B00M";
ATTRIBUTE WEIGHT of P1 : label is "N/A";
ATTRIBUTE \MPN STATUS\ of P1 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of P1 : label is "GRADCONN";
ATTRIBUTE \PACKING TYPE\ of P1 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of P1 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=91978";
ATTRIBUTE MTBF of P1 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of P1 : label is "N/A";
ATTRIBUTE PITCH:string;
ATTRIBUTE PITCH of P1 : label is "1.27mm";
ATTRIBUTE \RTD VOLTAGE\ of P1 : label is "30V";
ATTRIBUTE \MAX OPER TEMP\ of P1 : label is "+105DEGC";
ATTRIBUTE REVISION of P1 : label is "R001";
ATTRIBUTE \LAST TIME BUY\ of P1 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of P1 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of P1 : label is "1A";
ATTRIBUTE \DEFINIED QUALITY\ of P1 : label is "INDUSTRIAL";
ATTRIBUTE \NO OF ROWS\:string;
ATTRIBUTE \NO OF ROWS\ of P1 : label is "2";
ATTRIBUTE \DATASHEET URL 1\ of P1 : label is "N/A";
ATTRIBUTE \ROHS STATUS\ of P1 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of P1 : label is "CONNECTOR\HEADER";
ATTRIBUTE \MOUNTING TYPE\ of P1 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of P1 : label is "GRADCON_BB02BS101KA8025B00L,GRADCON_BB02BS101KA8025B00M";
ATTRIBUTE \MTBF STANDARD\ of R10 : label is "N/A";
ATTRIBUTE \MAX TC\ of R10 : label is "+200PPM/DEGC";
ATTRIBUTE \DATASHEET URL 2\ of R10 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R10 : label is "RESC1005X40N";
ATTRIBUTE \MIN TC\ of R10 : label is "-200PPM/DEGC";
ATTRIBUTE VOLTAGE of R10 : label is "RVMAX";
ATTRIBUTE MSL of R10 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of R10 : label is "10000";
ATTRIBUTE \BUDGET CURRENCY\ of R10 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of R10 : label is "0.014";
ATTRIBUTE \LIFECYCLE STATUS\ of R10 : label is "ACTIVE";
ATTRIBUTE \MIN OPER TEMP\ of R10 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R10 : label is "MISSING INFO";
ATTRIBUTE \RTD POWER\ of R10 : label is "0.063W";
ATTRIBUTE \PART NUMBER\ of R10 : label is "01-01219";
ATTRIBUTE DESCRIPTION of R10 : label is "RESISTOR, THICK FILM, 680, -5%/+5%, 0.063W, 50V, -55DEGC/+155DEGC, 0402, SMD";
ATTRIBUTE DIST of R10 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R10 : label is "-5%";
ATTRIBUTE \BU NAME\ of R10 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R10 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R10 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R10 : label is "0402";
ATTRIBUTE \MAX TOL\ of R10 : label is "+5%";
ATTRIBUTE MPN of R10 : label is "RESISTOR_0402_680_+/-5%_50V_0.063W_M_+/-200PPM";
ATTRIBUTE \ESD LEVEL\ of R10 : label is "N/A";
ATTRIBUTE WEIGHT of R10 : label is "0.00065g";
ATTRIBUTE \RESISTOR TYPE\ of R10 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER of R10 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \MPN STATUS\ of R10 : label is "ACTIVE";
ATTRIBUTE \PACKING TYPE\ of R10 : label is "TAPE_&_REEL";
ATTRIBUTE RESISTANCE of R10 : label is "680";
ATTRIBUTE \AUTODOC FILE\ of R10 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=47103";
ATTRIBUTE VENDOR of R10 : label is "VISHAY";
ATTRIBUTE MTBF of R10 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of R10 : label is "18";
ATTRIBUTE REVISION of R10 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of R10 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\ of R10 : label is "50V";
ATTRIBUTE \LAST TIME BUY\ of R10 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R10 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of R10 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of R10 : label is "INDUSTRIAL";
ATTRIBUTE \VENDOR PART NUMBER\ of R10 : label is "CRCW0402680RJNED";
ATTRIBUTE TC1 of R10 : label is "0";
ATTRIBUTE MAX_TEMP of R10 : label is "RTMAX";
ATTRIBUTE TC2 of R10 : label is "0";
ATTRIBUTE POWER of R10 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS of R10 : label is "RESC1005X40L,RESC1005X40M";
ATTRIBUTE \MOUNTING TYPE\ of R10 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R10 : label is "RESISTOR\0402\STANDARD";
ATTRIBUTE \ROHS STATUS\ of R10 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of R10 : label is "http://www.vishay.com/docs/20035/dcrcwe3.pdf";
ATTRIBUTE \DATASHEET URL 2\ of R12 : label is "N/A";
ATTRIBUTE \MTBF STANDARD\ of R12 : label is "N/A";
ATTRIBUTE \MAX TC\ of R12 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of R12 : label is "UNDER_REVIEW";
ATTRIBUTE \MIN TC\ of R12 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R12 : label is "RESC1005X40N";
ATTRIBUTE VOLTAGE of R12 : label is "RVMAX";
ATTRIBUTE MSL of R12 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of R12 : label is "10000";
ATTRIBUTE \BUDGET CURRENCY\ of R12 : label is "EUR";
ATTRIBUTE \BUDGET PRICE\ of R12 : label is "0.007";
ATTRIBUTE \LIFECYCLE STATUS\ of R12 : label is "ACTIVE";
ATTRIBUTE \MIN OPER TEMP\ of R12 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R12 : label is "ISRAEL";
ATTRIBUTE \RTD POWER\ of R12 : label is "0.063W";
ATTRIBUTE DESCRIPTION of R12 : label is "RESISTOR, THICK FILM, 0, 0.063W, 50V, -55DEGC/+155DEGC, 0402, SMD";
ATTRIBUTE \PART NUMBER\ of R12 : label is "01-16938";
ATTRIBUTE DIST of R12 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R12 : label is "N/A";
ATTRIBUTE \BU NAME\ of R12 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R12 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R12 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE MPN of R12 : label is "RESISTOR_0402_0_+/-5%_50V_0.063W_M_+/-200PPM";
ATTRIBUTE \MAX TOL\ of R12 : label is "N/A";
ATTRIBUTE \PCB PACKAGE\ of R12 : label is "0402";
ATTRIBUTE \ESD LEVEL\ of R12 : label is "N/A";
ATTRIBUTE WEIGHT of R12 : label is "0.0006152g";
ATTRIBUTE \MPN STATUS\ of R12 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of R12 : label is "MANUFACTURER SELECTION";
ATTRIBUTE \RESISTOR TYPE\ of R12 : label is "THICK FILM";
ATTRIBUTE \AUTODOC FILE\ of R12 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=86391";
ATTRIBUTE \PACKING TYPE\ of R12 : label is "TAPE_&_REEL";
ATTRIBUTE RESISTANCE of R12 : label is "0";
ATTRIBUTE VENDOR of R12 : label is "VISHAY";
ATTRIBUTE MTBF of R12 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of R12 : label is "14";
ATTRIBUTE \RTD VOLTAGE\ of R12 : label is "50V";
ATTRIBUTE \MAX OPER TEMP\ of R12 : label is "+155DEGC";
ATTRIBUTE REVISION of R12 : label is "R007";
ATTRIBUTE \LAST TIME BUY\ of R12 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R12 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of R12 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of R12 : label is "INDUSTRIAL";
ATTRIBUTE \VENDOR PART NUMBER\ of R12 : label is "CRCW04020000Z0ED";
ATTRIBUTE TC1 of R12 : label is "0";
ATTRIBUTE MAX_TEMP of R12 : label is "RTMAX";
ATTRIBUTE TC2 of R12 : label is "0";
ATTRIBUTE POWER of R12 : label is "RMAX";
ATTRIBUTE \DATASHEET URL 1\ of R12 : label is "http://www.vishay.com/docs/20035/dcrcwe3.pdf";
ATTRIBUTE \ROHS STATUS\ of R12 : label is "ROHS_COMPLIANT_WITH_EXEMPTION";
ATTRIBUTE \PART TYPE\ of R12 : label is "RESISTOR\0402\JUMPER";
ATTRIBUTE \MOUNTING TYPE\ of R12 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of R12 : label is "RESC1005X40A2L,RESC1005X40A2M";
ATTRIBUTE \DATASHEET URL 2\ of J2 : label is "http://www.samtec.com/documents/webfiles/pdf/lss.pdf";
ATTRIBUTE \MTBF STANDARD\ of J2 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of J2 : label is "SAMTEC_LSS-110-01-F-DV-A-TR-20N";
ATTRIBUTE MSL of J2 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of J2 : label is "125";
ATTRIBUTE \BUDGET CURRENCY\ of J2 : label is "USD";
ATTRIBUTE \BUDGET PRICE\ of J2 : label is "1.76";
ATTRIBUTE \MIN OPER TEMP\ of J2 : label is "-55DEGC";
ATTRIBUTE DESIGN_DATE of J2 : label is "2013-07-01";
ATTRIBUTE \NO OF POS\ of J2 : label is "20";
ATTRIBUTE DESCRIPTION of J2 : label is "CONNECTOR, HEADER,  HI-SPEED SOCKET, FEMALE, STRAIGHT, 2 ROWS,20 PINS, PITCH 0.635mm, SMD";
ATTRIBUTE \PART NUMBER\ of J2 : label is "06-03032";
ATTRIBUTE MPN of J2 : label is "LSS-110-01-F-DV-A-TR";
ATTRIBUTE \ESD LEVEL\ of J2 : label is "N/A";
ATTRIBUTE FPLIST of J2 : label is "SAMTEC_LSS-110-01-F-DV-A-TR-20N,SAMTEC_LSS-110-01-F-DV-A-TR-20L,SAMTEC_LSS-110-01-F-DV-A-TR-20M";
ATTRIBUTE WEIGHT of J2 : label is "N/A";
ATTRIBUTE \MPN STATUS\ of J2 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of J2 : label is "SAMTEC";
ATTRIBUTE \AUTODOC FILE\ of J2 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89361";
ATTRIBUTE \PACKING TYPE\ of J2 : label is "TAPE_&_REEL";
ATTRIBUTE MTBF of J2 : label is "N/A";
ATTRIBUTE \LEAD TIME\ of J2 : label is "1";
ATTRIBUTE PITCH of J2 : label is "0.635mm";
ATTRIBUTE DESIGNED_BY of J2 : label is "Artur Bielinski";
ATTRIBUTE \MAX OPER TEMP\ of J2 : label is "+125DEGC";
ATTRIBUTE REVISION of J2 : label is "R001";
ATTRIBUTE \LAST TIME BUY\ of J2 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of J2 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of J2 : label is "1.7A";
ATTRIBUTE \DEFINIED QUALITY\ of J2 : label is "COMMERCIAL";
ATTRIBUTE \NO OF ROWS\ of J2 : label is "2";
ATTRIBUTE \DATASHEET URL 1\ of J2 : label is "N/A";
ATTRIBUTE \ROHS STATUS\ of J2 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of J2 : label is "CONNECTOR\B2B";
ATTRIBUTE \MOUNTING TYPE\ of J2 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of J2 : label is "SAMTEC_LSS-110-01-F-DV-A-TR-20L,SAMTEC_LSS-110-01-F-DV-A-TR-20M";
ATTRIBUTE \DATASHEET URL 2\ of CR1 : label is "http://catalog.osram-os.com/jsp/download.jsp?rootPath=/media/&name=LS_L296.pdf&docPath=Graphics/00077119_0.pdf&url=/media//_en/Graphics/00077119_0.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of CR1 : label is "LEDC1708X67N";
ATTRIBUTE \PACKING SIZE\ of CR1 : label is "5000";
ATTRIBUTE \MIN OPER TEMP\ of CR1 : label is "-40DEGC";
ATTRIBUTE DESCRIPTION of CR1 : label is "OPTO, LED, SUPER RED COLOR, 630nm, 1.8V TO 2.3V, 0.06A, 0603, SMD";
ATTRIBUTE \PART NUMBER\ of CR1 : label is "15-01169";
ATTRIBUTE MPN of CR1 : label is "LS L296-P2Q2-1-Z";
ATTRIBUTE \PCB PACKAGE\ of CR1 : label is "0603";
ATTRIBUTE FPLIST of CR1 : label is "LEDC1708X67N,LEDC1708X67L,LEDC1708X67M";
ATTRIBUTE WEIGHT of CR1 : label is "0.002g";
ATTRIBUTE \MPN STATUS\ of CR1 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of CR1 : label is "OSRAM";
ATTRIBUTE \AUTODOC FILE\ of CR1 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=88355";
ATTRIBUTE \PACKING TYPE\ of CR1 : label is "TAPE_&_REEL";
ATTRIBUTE \RTD VOLTAGE\ of CR1 : label is "1.8V TO 2.3V";
ATTRIBUTE \MAX OPER TEMP\ of CR1 : label is "+100DEGC";
ATTRIBUTE REVISION of CR1 : label is "R002";
ATTRIBUTE \NOTE STATUS\ of CR1 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of CR1 : label is "0.06A";
ATTRIBUTE \ROHS STATUS\ of CR1 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of CR1 : label is "OPTO\LED\0603";
ATTRIBUTE \MOUNTING TYPE\ of CR1 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of CR1 : label is "LEDC1708X67L,LEDC1708X67M";
ATTRIBUTE \DATASHEET URL 2\ of SW1 : label is "http://diptronics.vitanspb.ru/component/content/article?id=19";
ATTRIBUTE \OLD FOOTPRINT\ of SW1 : label is "SW_MTA2AN";
ATTRIBUTE \PACKING SIZE\ of SW1 : label is "3000";
ATTRIBUTE \MIN OPER TEMP\ of SW1 : label is "-30DEGC";
ATTRIBUTE DESIGN_DATE of SW1 : label is "2009-09-28";
ATTRIBUTE DESCRIPTION of SW1 : label is "SWITCH, TACT SWITCH, RIGHT ANGLE, 0.05A@12VDC, SMD";
ATTRIBUTE \PART NUMBER\ of SW1 : label is "08-00142";
ATTRIBUTE MPN of SW1 : label is "MTA2-WNC-V-T/R";
ATTRIBUTE FPLIST of SW1 : label is "SW_MTA2AN,";
ATTRIBUTE \MPN STATUS\ of SW1 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of SW1 : label is "DIPTRONICS";
ATTRIBUTE \AUTODOC FILE\ of SW1 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89338";
ATTRIBUTE \PACKING TYPE\ of SW1 : label is "TAPE_&_REEL";
ATTRIBUTE DESIGNED_BY of SW1 : label is "Agnieszka Barczuk";
ATTRIBUTE \RTD VOLTAGE\ of SW1 : label is "12V";
ATTRIBUTE \MAX OPER TEMP\ of SW1 : label is "+80DEGC";
ATTRIBUTE REVISION of SW1 : label is "R002";
ATTRIBUTE \NOTE STATUS\ of SW1 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of SW1 : label is "0.05A";
ATTRIBUTE \ROHS STATUS\ of SW1 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of SW1 : label is "SWITCH\TACT";
ATTRIBUTE \MOUNTING TYPE\ of SW1 : label is "SMD";
ATTRIBUTE \DATASHEET URL 2\ of SW2 : label is "http://diptronics.vitanspb.ru/component/content/article?id=19";
ATTRIBUTE \OLD FOOTPRINT\ of SW2 : label is "SW_MTA2AN";
ATTRIBUTE \PACKING SIZE\ of SW2 : label is "3000";
ATTRIBUTE \MIN OPER TEMP\ of SW2 : label is "-30DEGC";
ATTRIBUTE DESIGN_DATE of SW2 : label is "2009-09-28";
ATTRIBUTE DESCRIPTION of SW2 : label is "SWITCH, TACT SWITCH, RIGHT ANGLE, 0.05A@12VDC, SMD";
ATTRIBUTE \PART NUMBER\ of SW2 : label is "08-00142";
ATTRIBUTE MPN of SW2 : label is "MTA2-WNC-V-T/R";
ATTRIBUTE FPLIST of SW2 : label is "SW_MTA2AN,";
ATTRIBUTE \MPN STATUS\ of SW2 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of SW2 : label is "DIPTRONICS";
ATTRIBUTE \AUTODOC FILE\ of SW2 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=89338";
ATTRIBUTE \PACKING TYPE\ of SW2 : label is "TAPE_&_REEL";
ATTRIBUTE DESIGNED_BY of SW2 : label is "Agnieszka Barczuk";
ATTRIBUTE \RTD VOLTAGE\ of SW2 : label is "12V";
ATTRIBUTE \MAX OPER TEMP\ of SW2 : label is "+80DEGC";
ATTRIBUTE REVISION of SW2 : label is "R002";
ATTRIBUTE \NOTE STATUS\ of SW2 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of SW2 : label is "0.05A";
ATTRIBUTE \ROHS STATUS\ of SW2 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of SW2 : label is "SWITCH\TACT";
ATTRIBUTE \MOUNTING TYPE\ of SW2 : label is "SMD";
ATTRIBUTE \DATASHEET URL 2\ of C40 : label is "N/A";
ATTRIBUTE \CLIENT STATUS\ of C40 : label is "UNDER_REVIEW";
ATTRIBUTE \OLD FOOTPRINT\ of C40 : label is "CAPC0603X35N";
ATTRIBUTE \LIFECYCLE STATUS\ of C40 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of C40 : label is "0.008";
ATTRIBUTE \BUDGET CURRENCY\ of C40 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of C40 : label is "15000";
ATTRIBUTE CURRENT of C40 : label is "CIMAX";
ATTRIBUTE KNEE of C40 : label is "CBMAX";
ATTRIBUTE \MIN OPER TEMP\ of C40 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of C40 : label is "MISSING INFO";
ATTRIBUTE DESCRIPTION of C40 : label is "CAPACITOR, CERAMIC X5R, 100nF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0201, SMD";
ATTRIBUTE \PART NUMBER\ of C40 : label is "02-06085";
ATTRIBUTE DIST of C40 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of C40 : label is "-10%";
ATTRIBUTE \BU NAME\ of C40 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of C40 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of C40 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C40 : label is "CSMAX";
ATTRIBUTE MPN of C40 : label is "CAPACITOR_0201_100nF_X5R_I_+/-10%_10V";
ATTRIBUTE \DIELECTRIC TYPE\ of C40 : label is "X5R";
ATTRIBUTE \MAX TOL\ of C40 : label is "+10%";
ATTRIBUTE \PCB PACKAGE\ of C40 : label is "0201";
ATTRIBUTE WEIGHT of C40 : label is "0.00033g";
ATTRIBUTE \MPN STATUS\ of C40 : label is "ACTIVE";
ATTRIBUTE MANUFACTURER of C40 : label is "MANUFACTURER SELECTION";
ATTRIBUTE CAPACITANCE of C40 : label is "100nF";
ATTRIBUTE \AUTODOC FILE\ of C40 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=96679";
ATTRIBUTE VENDOR of C40 : label is "MURATA";
ATTRIBUTE \PACKING TYPE\ of C40 : label is "TAPE_&_REEL";
ATTRIBUTE \LEAD TIME\ of C40 : label is "17";
ATTRIBUTE \RTD VOLTAGE\ of C40 : label is "10V";
ATTRIBUTE \MAX OPER TEMP\ of C40 : label is "+85DEGC";
ATTRIBUTE REVISION of C40 : label is "R002";
ATTRIBUTE \NOTE STATUS\ of C40 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of C40 : label is "N/A";
ATTRIBUTE \VENDOR PART NUMBER\ of C40 : label is "GRM033R61A104KE84D";
ATTRIBUTE MAX_TEMP of C40 : label is "CTMAX";
ATTRIBUTE TC1 of C40 : label is "0";
ATTRIBUTE TC2 of C40 : label is "0";
ATTRIBUTE \DATASHEET URL 1\ of C40 : label is "http://psearch.murata.com/capacitor/product/GRM033R61A104KE84%23.pdf";
ATTRIBUTE \ROHS STATUS\ of C40 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of C40 : label is "CAPACITOR\CERAMIC\0201\STANDARD";
ATTRIBUTE \MOUNTING TYPE\ of C40 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of C40 : label is "CAPC0603X35L,CAPC0603X35M";
ATTRIBUTE \MTBF STANDARD\ of C41 : label is "N/A";
ATTRIBUTE \DATASHEET URL 2\ of C41 : label is "http://psearch.murata.com/capacitor/product/GRM155R61A105KE15%23.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of C41 : label is "CAPC1005X60N,0402";
ATTRIBUTE \LIFECYCLE STATUS\ of C41 : label is "NRND";
ATTRIBUTE \BUDGET PRICE\ of C41 : label is "0.015";
ATTRIBUTE \BUDGET CURRENCY\ of C41 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of C41 : label is "10000";
ATTRIBUTE MSL of C41 : label is "1";
ATTRIBUTE CURRENT of C41 : label is "CIMAX";
ATTRIBUTE KNEE of C41 : label is "CBMAX";
ATTRIBUTE \MIN OPER TEMP\ of C41 : label is "-55DEGC";
ATTRIBUTE \PART NUMBER\ of C41 : label is "02-02381";
ATTRIBUTE DESCRIPTION of C41 : label is "CAPACITOR, CERAMIC X5R, 1uF, 10V, -10%/+10%, -55DEGC/+85DEGC, 0402, SMD";
ATTRIBUTE DIST of C41 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of C41 : label is "-10%";
ATTRIBUTE PSPICETEMPLATE of C41 : label is "C^@REFDES %1 %2 ?TOLERANCE|C^@REFDES| @VALUE ?IC/IC=@IC/ TC=@TC1,@TC2 ?TOLERANCE|\n.model C^@REFDES CAP C=1 DEV=@TOLERANCE%|";
ATTRIBUTE SLOPE of C41 : label is "CSMAX";
ATTRIBUTE \PCB PACKAGE\ of C41 : label is "0402";
ATTRIBUTE \MAX TOL\ of C41 : label is "+10%";
ATTRIBUTE \DIELECTRIC TYPE\ of C41 : label is "X5R";
ATTRIBUTE MPN of C41 : label is "GRM155R61A105KE15D";
ATTRIBUTE \ESD LEVEL\ of C41 : label is "N/A";
ATTRIBUTE CAPACITANCE of C41 : label is "1uF";
ATTRIBUTE MANUFACTURER of C41 : label is "MURATA";
ATTRIBUTE \MPN STATUS\ of C41 : label is "NRND";
ATTRIBUTE WEIGHT of C41 : label is "0.0016g";
ATTRIBUTE \PACKING TYPE\ of C41 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of C41 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=74236";
ATTRIBUTE \LEAD TIME\ of C41 : label is "14";
ATTRIBUTE MTBF of C41 : label is "N/A";
ATTRIBUTE REVISION of C41 : label is "R005";
ATTRIBUTE \MAX OPER TEMP\ of C41 : label is "+85DEGC";
ATTRIBUTE \RTD VOLTAGE\ of C41 : label is "10V";
ATTRIBUTE \NOTE STATUS\ of C41 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of C41 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of C41 : label is "INDUSTRIAL";
ATTRIBUTE MAX_TEMP of C41 : label is "CTMAX";
ATTRIBUTE TC1 of C41 : label is "0";
ATTRIBUTE TC2 of C41 : label is "0";
ATTRIBUTE ALT_SYMBOLS of C41 : label is "CAPC1005X60L,CAPC1005X60M";
ATTRIBUTE \MOUNTING TYPE\ of C41 : label is "SMD";
ATTRIBUTE \PART TYPE\ of C41 : label is "CAPACITOR\CERAMIC\0402";
ATTRIBUTE \ROHS STATUS\ of C41 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of C41 : label is "http://search.murata.co.jp/Ceramy/image/img/w_hinm/L0005E.pdf";
ATTRIBUTE \MTBF STANDARD\ of Q1 : label is "AEC-Q101, Ta=55degC, CL=60%, Ea=0.7eV";
ATTRIBUTE \DATASHEET URL 2\ of Q1 : label is "http://www.nxp.com/documents/data_sheet/BC846_SER.pdf";
ATTRIBUTE \OLD FOOTPRINT\ of Q1 : label is "SOT95P237X130-3N,SOT23_3";
ATTRIBUTE \LIFECYCLE STATUS\ of Q1 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of Q1 : label is "0.01";
ATTRIBUTE \BUDGET CURRENCY\ of Q1 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of Q1 : label is "3000";
ATTRIBUTE MSL of Q1 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\ of Q1 : label is "-65DEGC";
ATTRIBUTE \RTD POWER\ of Q1 : label is "0.25W";
ATTRIBUTE \PART NUMBER\ of Q1 : label is "16-00000";
ATTRIBUTE DESCRIPTION of Q1 : label is "TRANSISTOR, BIPOLAR NPN, 65V, 0.1A, 0.25W, SOT-23, SMD";
ATTRIBUTE \PCB PACKAGE\ of Q1 : label is "SOT23-3";
ATTRIBUTE MPN of Q1 : label is "BC846B,215";
ATTRIBUTE FPLIST of Q1 : label is "SOT95P237X130-3N,SOT95P237X130-3L,SOT95P237X130-3M";
ATTRIBUTE \ESD LEVEL\ of Q1 : label is "N/A";
ATTRIBUTE MANUFACTURER of Q1 : label is "NXP";
ATTRIBUTE \MPN STATUS\ of Q1 : label is "ACTIVE";
ATTRIBUTE WEIGHT of Q1 : label is "0.0075g";
ATTRIBUTE \PACKING TYPE\ of Q1 : label is "TAPE_&_REEL";
ATTRIBUTE \AUTODOC FILE\ of Q1 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=13377";
ATTRIBUTE \LEAD TIME\ of Q1 : label is "N/A";
ATTRIBUTE MTBF of Q1 : label is "1.22*10^9";
ATTRIBUTE REVISION of Q1 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of Q1 : label is "+150DEGC";
ATTRIBUTE \RTD VOLTAGE\ of Q1 : label is "65V";
ATTRIBUTE \RTD CURRENT\ of Q1 : label is "0.1A ";
ATTRIBUTE \NOTE STATUS\ of Q1 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of Q1 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of Q1 : label is "INDUSTRIAL";
ATTRIBUTE ALT_SYMBOLS of Q1 : label is "SOT95P237X130-3L,SOT95P237X130-3M";
ATTRIBUTE \MOUNTING TYPE\ of Q1 : label is "SMD";
ATTRIBUTE \PART TYPE\ of Q1 : label is "TRANSISTOR\BIPOLAR\NPN";
ATTRIBUTE \ROHS STATUS\ of Q1 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of Q1 : label is "N/A";
ATTRIBUTE \MAX TC\ of R21 : label is "+200PPM/DEGC";
ATTRIBUTE \DATASHEET URL 2\ of R21 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R21 : label is "RESC1005X40N,0402";
ATTRIBUTE \MIN TC\ of R21 : label is "-200PPM/DEGC";
ATTRIBUTE VOLTAGE of R21 : label is "RVMAX";
ATTRIBUTE \LIFECYCLE STATUS\ of R21 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of R21 : label is "0.014";
ATTRIBUTE \BUDGET CURRENCY\ of R21 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of R21 : label is "10000";
ATTRIBUTE \MIN OPER TEMP\ of R21 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R21 : label is "ISRAEL";
ATTRIBUTE \RTD POWER\ of R21 : label is "0.063W";
ATTRIBUTE \PART NUMBER\ of R21 : label is "01-01209";
ATTRIBUTE DESCRIPTION of R21 : label is "RESISTOR, THICK FILM, 270, -5%/+5%, 0.063W, 50V, -55DEGC/+155DEGC, 0402, SMD";
ATTRIBUTE DIST of R21 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R21 : label is "-5%";
ATTRIBUTE \BU NAME\ of R21 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R21 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R21 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R21 : label is "0402";
ATTRIBUTE \MAX TOL\ of R21 : label is "+5%";
ATTRIBUTE MPN of R21 : label is "239040742700";
ATTRIBUTE \RESISTOR TYPE\ of R21 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER of R21 : label is "YAGEO";
ATTRIBUTE \MPN STATUS\ of R21 : label is "ACTIVE";
ATTRIBUTE WEIGHT of R21 : label is "0.00065g";
ATTRIBUTE RESISTANCE of R21 : label is "270";
ATTRIBUTE \AUTODOC FILE\ of R21 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=47093";
ATTRIBUTE VENDOR of R21 : label is "VISHAY";
ATTRIBUTE \PACKING TYPE\ of R21 : label is "TAPE_&_REEL";
ATTRIBUTE \LEAD TIME\ of R21 : label is "18";
ATTRIBUTE REVISION of R21 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of R21 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\ of R21 : label is "50V";
ATTRIBUTE \NOTE STATUS\ of R21 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of R21 : label is "N/A";
ATTRIBUTE \LAST TIME BUY\ of R21 : label is "N/A";
ATTRIBUTE \VENDOR PART NUMBER\ of R21 : label is "CRCW0402270RJNED";
ATTRIBUTE TC1 of R21 : label is "0";
ATTRIBUTE MAX_TEMP of R21 : label is "RTMAX";
ATTRIBUTE TC2 of R21 : label is "0";
ATTRIBUTE POWER of R21 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS of R21 : label is "RESC1005X40L,RESC1005X40M";
ATTRIBUTE \MOUNTING TYPE\ of R21 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R21 : label is "RESISTOR\0402\STANDARD";
ATTRIBUTE \ROHS STATUS\ of R21 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of R21 : label is "http://www.vishay.com/docs/20035/dcrcwe3.pdf";
ATTRIBUTE \DATASHEET URL 2\ of U10 : label is "http://www.macronix.com/en-us/Product/Pages/ProductDetail.aspx?PartNo=MX25R8035F";
ATTRIBUTE \CLIENT STATUS\ of U10 : label is "UNDER_REVIEW";
ATTRIBUTE \MIN OPER TEMP\ of U10 : label is "-40DEGC";
ATTRIBUTE DESIGN_DATE of U10 : label is "2015-08-05";
ATTRIBUTE CLASS of U10 : label is "IC";
ATTRIBUTE DESCRIPTION of U10 : label is "IC, MEMORY, FLASH, SERIAL, 8Mbit, 1.65V TO 3.6V, USON8, SMD";
ATTRIBUTE \PART NUMBER\ of U10 : label is "18-31726";
ATTRIBUTE \VENDOR PART STATUS\ of U10 : label is "ACTIVE";
ATTRIBUTE \BU NAME\ of U10 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \PCB PACKAGE\ of U10 : label is "USON8";
ATTRIBUTE \AUTODOC FILE\ of U10 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=104624";
ATTRIBUTE VENDOR of U10 : label is "MACRONIX";
ATTRIBUTE DESIGNED_BY of U10 : label is "Artur Bielinski";
ATTRIBUTE \RTD VOLTAGE\ of U10 : label is "1.65V TO 3.6V";
ATTRIBUTE \MAX OPER TEMP\ of U10 : label is "+85DEGC";
ATTRIBUTE REVISION of U10 : label is "R001";
ATTRIBUTE \LAST TIME BUY\ of U10 : label is "N/A";
ATTRIBUTE \VENDOR PART NUMBER\ of U10 : label is "MX25R8035FZUIL0";
ATTRIBUTE \DATASHEET URL 1\ of U10 : label is "http://www.macronix.com/Lists/DataSheet/Attachments/2656/MX25R8035F,%20Wide%20Range,%208Mb,%20v1.1.pdf";
ATTRIBUTE \ROHS STATUS\ of U10 : label is "ROHS_COMPLIANT";
ATTRIBUTE \PART TYPE\ of U10 : label is "IC\MEMORY\FLASH\OTHER";
ATTRIBUTE \MOUNTING TYPE\ of U10 : label is "SMD";
ATTRIBUTE ALT_SYMBOLS of U10 : label is "SON50P300X200X60-9B2L,SON50P300X200X60-9B2M";
ATTRIBUTE \MAX TC\ of R22 : label is "+200PPM/DEGC";
ATTRIBUTE \DATASHEET URL 2\ of R22 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R22 : label is "RESC1005X40N,0402";
ATTRIBUTE \MIN TC\ of R22 : label is "-200PPM/DEGC";
ATTRIBUTE VOLTAGE of R22 : label is "RVMAX";
ATTRIBUTE \LIFECYCLE STATUS\ of R22 : label is "ACTIVE";
ATTRIBUTE \BUDGET PRICE\ of R22 : label is "0.014";
ATTRIBUTE \BUDGET CURRENCY\ of R22 : label is "EUR";
ATTRIBUTE \PACKING SIZE\ of R22 : label is "10000";
ATTRIBUTE \MIN OPER TEMP\ of R22 : label is "-55DEGC";
ATTRIBUTE \COUNTRY OF ORIGIN\ of R22 : label is "ISRAEL";
ATTRIBUTE \RTD POWER\ of R22 : label is "0.063W";
ATTRIBUTE \PART NUMBER\ of R22 : label is "01-01209";
ATTRIBUTE DESCRIPTION of R22 : label is "RESISTOR, THICK FILM, 270, -5%/+5%, 0.063W, 50V, -55DEGC/+155DEGC, 0402, SMD";
ATTRIBUTE DIST of R22 : label is "FLAT";
ATTRIBUTE \MIN TOL\ of R22 : label is "-5%";
ATTRIBUTE \BU NAME\ of R22 : label is "DYNAMIC PRECISION GDANSK";
ATTRIBUTE \VENDOR PART STATUS\ of R22 : label is "ACTIVE";
ATTRIBUTE PSPICETEMPLATE of R22 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R22 : label is "0402";
ATTRIBUTE \MAX TOL\ of R22 : label is "+5%";
ATTRIBUTE MPN of R22 : label is "239040742700";
ATTRIBUTE \RESISTOR TYPE\ of R22 : label is "THICK FILM";
ATTRIBUTE MANUFACTURER of R22 : label is "YAGEO";
ATTRIBUTE \MPN STATUS\ of R22 : label is "ACTIVE";
ATTRIBUTE WEIGHT of R22 : label is "0.00065g";
ATTRIBUTE RESISTANCE of R22 : label is "270";
ATTRIBUTE \AUTODOC FILE\ of R22 : label is "https://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=47093";
ATTRIBUTE VENDOR of R22 : label is "VISHAY";
ATTRIBUTE \PACKING TYPE\ of R22 : label is "TAPE_&_REEL";
ATTRIBUTE \LEAD TIME\ of R22 : label is "18";
ATTRIBUTE REVISION of R22 : label is "R001";
ATTRIBUTE \MAX OPER TEMP\ of R22 : label is "+155DEGC";
ATTRIBUTE \RTD VOLTAGE\ of R22 : label is "50V";
ATTRIBUTE \NOTE STATUS\ of R22 : label is "PREFERRED";
ATTRIBUTE \RTD CURRENT\ of R22 : label is "N/A";
ATTRIBUTE \LAST TIME BUY\ of R22 : label is "N/A";
ATTRIBUTE \VENDOR PART NUMBER\ of R22 : label is "CRCW0402270RJNED";
ATTRIBUTE TC1 of R22 : label is "0";
ATTRIBUTE MAX_TEMP of R22 : label is "RTMAX";
ATTRIBUTE TC2 of R22 : label is "0";
ATTRIBUTE POWER of R22 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS of R22 : label is "RESC1005X40L,RESC1005X40M";
ATTRIBUTE \MOUNTING TYPE\ of R22 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R22 : label is "RESISTOR\0402\STANDARD";
ATTRIBUTE \ROHS STATUS\ of R22 : label is "ROHS_COMPLIANT";
ATTRIBUTE \DATASHEET URL 1\ of R22 : label is "http://www.vishay.com/docs/20035/dcrcwe3.pdf";
ATTRIBUTE \MTBF STANDARD\ of R23 : label is "N/A";
ATTRIBUTE \DATASHEET URL 2\ of R23 : label is "N/A";
ATTRIBUTE \OLD FOOTPRINT\ of R23 : label is "RESC1005X40N,0402";
ATTRIBUTE VOLTAGE of R23 : label is "RVMAX";
ATTRIBUTE \BUDGET PRICE\ of R23 : label is "N/A";
ATTRIBUTE \BUDGET CURRENCY\ of R23 : label is "N/A";
ATTRIBUTE \PACKING SIZE\ of R23 : label is "N/A";
ATTRIBUTE MSL of R23 : label is "N/A";
ATTRIBUTE \MIN OPER TEMP\ of R23 : label is "N/A";
ATTRIBUTE \PART NUMBER\ of R23 : label is "01-02472";
ATTRIBUTE DESCRIPTION of R23 : label is "RESISTOR, DO NOT MOUNT, 0402, SMD";
ATTRIBUTE DIST of R23 : label is "FLAT";
ATTRIBUTE PSPICETEMPLATE of R23 : label is "R^@REFDES %1 %2 ?TOLERANCE|R^@REFDES| @VALUE TC=@TC1,@TC2 ?TOLERANCE|\n.model R^@REFDES RES R=1 DEV=@TOLERANCE%|";
ATTRIBUTE \PCB PACKAGE\ of R23 : label is "0402";
ATTRIBUTE MPN of R23 : label is "DNM";
ATTRIBUTE FPLIST of R23 : label is "RESC1005X40N,RESC1005X40L,RESC1005X40M";
ATTRIBUTE \ESD LEVEL\ of R23 : label is "N/A";
ATTRIBUTE MANUFACTURER of R23 : label is "DO NOT MOUNT";
ATTRIBUTE \MPN STATUS\ of R23 : label is "ACTIVE";
ATTRIBUTE WEIGHT of R23 : label is "N/A";
ATTRIBUTE \PACKING TYPE\ of R23 : label is "N/A";
ATTRIBUTE \AUTODOC FILE\ of R23 : label is "http://notefied-dynamic-precision.com/DB/Apps/Desktop/Item/Object.aspx?id=48356";
ATTRIBUTE \LEAD TIME\ of R23 : label is "N/A";
ATTRIBUTE MTBF of R23 : label is "N/A";
ATTRIBUTE REVISION of R23 : label is "R002";
ATTRIBUTE \MAX OPER TEMP\ of R23 : label is "N/A";
ATTRIBUTE \NOTE STATUS\ of R23 : label is "PREFERRED";
ATTRIBUTE \LAST TIME BUY\ of R23 : label is "N/A";
ATTRIBUTE \DEFINIED QUALITY\ of R23 : label is "N/A";
ATTRIBUTE TC1 of R23 : label is "0";
ATTRIBUTE MAX_TEMP of R23 : label is "RTMAX";
ATTRIBUTE TC2 of R23 : label is "0";
ATTRIBUTE POWER of R23 : label is "RMAX";
ATTRIBUTE ALT_SYMBOLS of R23 : label is "RESC1005X40L,RESC1005X40M";
ATTRIBUTE \MOUNTING TYPE\ of R23 : label is "SMD";
ATTRIBUTE \PART TYPE\ of R23 : label is "RESISTOR\0402";
ATTRIBUTE \ROHS STATUS\ of R23 : label is "PART NOT KNOWN";
ATTRIBUTE \DATASHEET URL 1\ of R23 : label is "N/A";


-- GATE INSTANCES

BEGIN
\DP10/MOSI\<=N591139;
\DP9/MISO\<=N591143;
R26 : \0\	PORT MAP(
	\1\ => N620089, 
	\2\ => VDD_BATT
);
R28 : \100k\	PORT MAP(
	\1\ => GND, 
	\2\ => \POWER GOOD\
);
U2 : TPS22910AYZV	PORT MAP(
	GND => GND, 
	VIN => N567147, 
	VOUT => VDD, 
	\ON\ => \POWER GOOD\
);
\BAT+\ : \BAT+\	PORT MAP(
	\1\ => N620089
);
C28 : \100nF\	PORT MAP(
	\1\ => VDD, 
	\2\ => GND
);
R33 : \2.2k\	PORT MAP(
	\1\ => FLASH_CS, 
	\2\ => VDD
);
\BAT-\ : \BAT-\	PORT MAP(
	\1\ => GND
);
R7 : \10k\	PORT MAP(
	\1\ => N553749, 
	\2\ => BUZZER
);
R8 : \5.1\	PORT MAP(
	\1\ => GND, 
	\2\ => N553802
);
R9 : \0\	PORT MAP(
	\1\ => VDD, 
	\2\ => \DEVPACK->VDD\
);
BZ1 : HCS0503B	PORT MAP(
	\2\ => N553359, 
	\1\ => VDD, 
	NC => OPEN
);
BT1 : \BAT-HLD-001\	PORT MAP(
	\+\ => VDD_BATT, 
	\-\ => GND
);
P1 : \BB02-BS101-KA8-025B00\	PORT MAP(
	\2\ => JTAG_TMS, 
	\4\ => JTAG_TCK, 
	\6\ => \DP12/AUDIO FS/TDO\, 
	\8\ => \DP8/SCLK/TDI\, 
	\10\ => NRESET, 
	\1\ => VDD, 
	\3\ => GND, 
	\5\ => GND, 
	\7\ => OPEN, 
	\9\ => GND
);
R10 : \680\	PORT MAP(
	\1\ => GND, 
	\2\ => N256047
);
R12 : \0\	PORT MAP(
	\1\ => VDD_BATT, 
	\2\ => N567147
);
J2 : \LSS-110-01-F-DV-A-TR\	PORT MAP(
	\1\ => VDD, 
	\3\ => SCL, 
	\5\ => \DP12/AUDIO FS/TDO\, 
	\7\ => \DP11/CSN\, 
	\9\ => \DEVPACK->VDD\, 
	\11\ => N591139, 
	\13\ => N591143, 
	\15\ => \DP8/SCLK/TDI\, 
	\17\ => DP_ID, 
	\19\ => \POWER GOOD\, 
	\2\ => GND, 
	\4\ => SDA, 
	\6\ => \DP7/AUDIO CLK\, 
	\8\ => \DP6/AUDIO DO\, 
	\10\ => \DP5/UART_TX\, 
	\12\ => \DP4/UART_RX\, 
	\14\ => DP3, 
	\16\ => DP2, 
	\18\ => DP1, 
	\20\ => DP0
);
CR1 : \LS L296-P2Q2-1\	PORT MAP(
	A => LED1, 
	C => N256047
);
SW1 : \MTA2-WNC\	PORT MAP(
	\1\ => GND, 
	\2\ => N593616
);
SW2 : \MTA2-WNC\	PORT MAP(
	\1\ => GND, 
	\2\ => N593675
);
C40 : \100nF\	PORT MAP(
	\1\ => VDD, 
	\2\ => GND
);
C41 : \1uF\	PORT MAP(
	\1\ => N567147, 
	\2\ => GND
);
Q1 : BC846B	PORT MAP(
	BASE => N553749, 
	COLLECTOR => N553359, 
	EMITTER => N553802
);
R21 : \270\	PORT MAP(
	\1\ => N593616, 
	\2\ => BUTTON1
);
U10 : MX25R8035FZUIL0	PORT MAP(
	nCS => FLASH_CS, 
	\SO/SIO1\ => N591143, 
	\nWP/SIO2\ => OPEN, 
	GND => GND, 
	\SI/SIO0\ => N591139, 
	SCLK => \DP8/SCLK/TDI\, 
	\nRST/SIO3\ => OPEN, 
	VCC => VDD, 
	EGP => GND
);
R22 : \270\	PORT MAP(
	\1\ => N593675, 
	\2\ => BUTTON2
);
R23 : DNM	PORT MAP(
	\1\ => \DEVPACK->VDD\, 
	\2\ => N567147
);
END STRUCTURE;

LIBRARY IEEE;
USE IEEE.std_logic_1164.all;

ARCHITECTURE STRUCTURE OF \CC1350 SensorTag\ IS
END STRUCTURE;

