function [  ] = Sp_plot2( Pc_x, Pc_y, Ps_x1, Ps_y1, Ps_x2, Ps_y2, line_lvl )
%Sp_plot2 plots spurious emission
%Pc_x: Carrier frequencies
%Pc_y: Carrier trace
%Ps_x1: Spurious frequencies to the left
%Ps_y1: Spurious trace to the left
%Ps_x2: Spurious frequencies to the right
%Ps_y2: Spurious trace to the right
%line_lvl: Horizontal line level

figure();

%Plot spurious frequencies to the left from 915 MHz to the first carrier
%unit channel.
h1 = plot(Ps_x1, Ps_y1, 'g');
xlim([Ps_x1(1) Ps_x2(length(Ps_x2))]);
hold on;
%Plot spurious frequencies to the right from the last carrier unit channel
%up to 930 MHz.
h2 = plot(Ps_x2, Ps_y2, 'g');
%Plot horizontal line
h3 = plot([Ps_x1(1) Ps_x2(length(Ps_x2))],[line_lvl line_lvl], 'r');
%Plot carrier frequencies
h4 = plot(Pc_x, Pc_y);

title('Spurious emission measurement, overview');
legend([h1 h3 h4], 'Spurious frequencies', 'Technical standard', 'Carrier frequencies', 'Location', 'SouthOutside');
xlabel('Frequency [MHz]');
ylabel('Amplitude [dBm]');
hold off;

end

