function [  ] = Sp_plot( f_center, Pc_x, Pc_y, Ps_x, Ps_y, line_lvl, c_lines, sp_lines, Pb, Pc, Ps, Se )
%Sp_plot plots spurious emission
%Pc_x: Carrier frequencies
%Pc_y: Carrier trace
%Ps_x: Spurious frequencies to the left and right of carrier
%Ps_y: Spurious trace to the left and right of carrier
%line_lvl: Horizontal line level
%c_lines: Number of carrier unit channels
%sp_lines: Number of spurious unit channels (total)
%Se: Spurious emission power in mW (Ps/Pc)*Pb

%Calculate total number of vertical lines (unit channels)
vlines = c_lines + sp_lines;

figure('Position', [100, 100, 900, 700]);

%Plot spurious frequencies to the left from the first spurious unit channel
%to the first carrier unit channel.
h1 = plot(Ps_x(1:length(Ps_x)/2), Ps_y(1:length(Ps_y)/2), 'g');
xlim([Ps_x(1) Ps_x(length(Ps_x))]);
hold on;
%Plot spurious frequencies to the right from the last carrier unit channel
%to the last spurious unit channel.
h2 = plot(Ps_x(length(Ps_x)/2 + 1:length(Ps_x)), Ps_y(length(Ps_y)/2 + 1:length(Ps_y)), 'g');
%Generate y-limit
y_max = round((max(Pc_y)+10)/10)*10;
y_min = round((min(Ps_y)-10)/10)*10;
ylim([y_min y_max]);
%Plot horizontal line
h3 = plot([Ps_x(1) Ps_x(length(Ps_x))],[line_lvl line_lvl], 'r');
%Plot carrier frequencies
h4 = plot(Pc_x, Pc_y);

%Title with results
title(sprintf(['Spurious emission measurement, close up\n',...
    'Center frequency = ', num2str(f_center), ' MHz\n',...
    'Average power Pb = ', num2str(Pb), ' mW [', num2str(10*log10(Pb)), ' dBm]\n',...
    'Carrier power Pc = ', num2str(Pc), ' mW [', num2str(10*log10(Pc)), ' dBm]\n',...
    'Spourious emission power Ps = ', num2str(Ps), ' mW [', num2str(10*log10(Ps)), ' dBm]\n',...
    'Unwanted emission power (Ps/Pc)*Pb = ', num2str(Se), ' mW [', num2str(10*log10(Se)), ' dBm]']));
legend([h1 h3 h4], 'Spurious frequencies',...
    ['Technical standard (', num2str(line_lvl),...
    ' dBm)'], ['Carrier frequencies (', num2str(c_lines),...
    ' unit channel(s))'], 'Location', 'SouthOutside');
xlabel('Frequency [MHz]');
ylabel('Amplitude [dBm]');

%Generate vertical lines to indicate unit channels
df = (Ps_x(end)-Ps_x(1))/vlines;
for i = 0:vlines
    line([(Ps_x(1)+i*df) (Ps_x(1)+i*df)], [y_min y_max], 'Color', 'm')
end
hold off;

end

