----------------------------------------------------------------------------------
-- Company:  Spectrum Digital
-- Engineer: Tony C
-- 
-- Create Date:    2/21/2013
-- Design Name:    Video Mux 1
-- Module Name:     
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- 2/21/2013 - Initial Release
--
-- 3/30/2013 - Add latch controlled by gpio_1_3 to latch the mux/demux selectors.
--             This was required since DM814x signals driving the muxes were not
--             GPIO.  The theory now is to set the signals as GMPC then toggle
--             gpio_1_3 low and high to capture.
--
-- 4/2/2013  - Add a switch for mux/demux since the latch signal gpio_1_3 is not
--             pinned on the interposer.
--
-- 4/12/2013 - Shift omni camera data down 2 positon d9-d2 to vin d7-d0 
--
-- 5/2/2013  - Change SW(7 downto 0) to SW( 8 downto 1) to match SW marking.
--
-- 5/6/2013 - TI Request
--  Omni…operates either 8b or 10b modes.  When 8b – need to remap camera’s 
--    D9-D2 down to VIP D7-D0.  When 10b – direct mapping.
--  Aptina…operates in 12b or 8b modes.  When 8b – need to remap camera’s 
--    D12-D4 down to VIP D7-D0.  When 12b – direct mapping.
--  Leopard…(same as Aptina)
--  FPD Link…no re-mapping, everything is direct mapping.
--
-- 7/12/2013 - TI Request
--   Apply the 8 bit camera shift to the FPD Link CAM1
-- 
-- 10/7/2013 - TI Request
--   TI wants both SW(6) and DeMux_FPD_B to select shift mode.
-- Additional Comments: 
-- The 5M2210ZF256C5N or 324 will route at under 1ns of skew.  The 1270 will route
-- in -4 speed grade.  You have to let the tool select the pinout to meet skew.
-- Forcing the output into just 1 or 2 banks did not work.
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity video_mux is
port(

   mux1_sel        : in std_logic_vector( 1 downto 0 );
   mux2_sel        : in std_logic_vector( 1 downto 0 );
   DeMux_FPD_A     : in std_logic;
   DeMux_FPD_B     : in std_logic;
   DeMux_FPD_C     : in std_logic;
   
   li_cmos_pclk    : in std_logic;
   li_vert_sync    : in std_logic;
   li_hori_sync    : in std_logic;
   li_cam_d        : in std_logic_vector(13 downto 0 );
   li_cmos_rst     : out std_logic;
   
   ov_1plck        : in std_logic;
   ov_1vsync       : in std_logic;
   ov_1href        : in std_logic;
   ov_1y           : in std_logic_vector(9 downto 0 );
   
   apt_cam_bpxclk  : in std_logic;
   apt_cam_bframe  : in std_logic;   
   apt_cam_bline   : in std_logic;
   apt_cam_bd      : in std_logic_vector(11 downto 0 );
   apt_cam_rst     : out std_logic;
   
   vi_odck         : in std_logic;
   vi_vsync        : in std_logic;
   vi_hsync        : in std_logic;
   vi_de           : in std_logic;
   vi_qe           : in std_logic_vector(23 downto 0 );
   vi_reset        : out std_logic;
   
   cam1_pclk       : in std_logic;
   cam1_hs         : in std_logic;
   cam1_d          : in std_logic_vector(9 downto 1);
   cam1_d0_cam1_vs : in std_logic;
   cam5_d1_cam1_vs : in std_logic;
   cam5_d2_cam1_d10 : in std_logic;
   cam5_d3_cam1_d11 : in std_logic;
   
   cam3_pclk         : in std_logic;
   cam3_hsync        : in std_logic;
   cam3_d0_cam3_vs   : in std_logic;
   cam6_d1_cam3_vs   : in std_logic;
   cam6_d2_cam3_d10  : in std_logic;
   cam6_d3_cam3_d11  : in std_logic;
   cam3_d            : in std_logic_vector(9 downto 1 );
   
   -- vin3a(7 downto 0 ) show up on vina_d(23 downto 16)
   vin2a_d 	        : out std_logic_vector(19 downto 16 ); 
   vin1b_clk1       : out std_logic;
   vin2a_d22        : out std_logic;
   vin2a_d23        : out std_logic;
   
   vin1a_d         : out std_logic_vector(23 downto 0 );
   vin1a_clk0      : out std_logic;
   vin1a_hsync     : out std_logic;
   vin1a_vsync     : out std_logic;
   vin1a_de        : out std_logic;
   gpio_1_3        : in  std_logic;
   app_bd_porz     : in  std_logic;
   tp              : out std_logic_vector(54 downto 40);
   sw              : in  std_logic_vector(8 downto 1));
end video_mux;

architecture Behavioral of video_mux is
    
   constant   mode_8bit    : std_logic_vector( 2 downto 0 ) := "101";
   constant   mode_12bit   : std_logic_vector( 2 downto 0 ) := "010";
   
   signal mux1_in1         : std_logic_vector(16 downto 0);
   signal mux1_in2         : std_logic_vector(16 downto 0);
   signal mux1_in3         : std_logic_vector(16 downto 0);
   signal pro_cam          : std_logic_vector(16 downto 0 );
      
   signal mux2_in1         : std_logic_vector(27 downto 0);
   signal mux2_in2         : std_logic_vector(27 downto 0);
   signal mux2_in3         : std_logic_vector(27 downto 0);
   signal mux2_out         : std_logic_vector(27 downto 0);
   
   signal li_sel           : std_logic;
   signal apt_sel          : std_logic;
 	 signal vi_sel           : std_logic;
   signal ov_sel           : std_logic;
   
   signal cam1_d0          : std_logic;
   signal cam1_d10         : std_logic;
   signal cam1_d11         : std_logic;
   signal cam1_vs          : std_logic;
  
   signal vs_12bit         : std_logic;
   signal vs_8bit          : std_logic;
   signal cam1_vssel       : std_logic_vector( 2 downto 0 );
   signal cam1_vs8bit      : std_logic;
   signal cam1_vs12bit     : std_logic;
   
   signal cam3_vs          : std_logic;
   signal cam3_d11         : std_logic;
   signal cam3_d10         : std_logic;
   signal cam3_d0          : std_logic; 
   signal cam3_dm          : std_logic_vector(11 downto 0 );   
   signal cam3_vs8bit      : std_logic;
   signal cam3_vs12bit     : std_logic;
   
   signal reset            : std_logic;
  
   
   signal sg_mux1_sel      : std_logic_vector( 1 downto 0 );
   signal sg_mux2_sel      : std_logic_vector( 1 downto 0 );
   signal sg_DeMux_FPD_A   : std_logic;
   signal sg_DeMux_FPD_B   : std_logic;
   signal sg_DeMux_FPD_C   : std_logic;
   
   signal mux_ov_data      : std_logic_vector( 13 downto 0);
   signal mux_apt_data     : std_logic_vector( 13 downto 0);
   signal mux_li_data      : std_logic_vector( 13 downto 0);
   signal mux_cam_data     : std_logic_vector( 23 downto 0);
   
   signal cam_shift        : std_logic;
   
begin
  
  -- Switch(8) open or no switch installed use orignal selection.
  -- Switch(8) closed then use the switch selection inputs.
  sg_mux1_sel    <= mux1_sel(1 downto 0) when sw(8) = '1' else sw(2 downto 1);
  sg_mux2_sel    <= mux2_sel(1 downto 0) when sw(8) = '1' else sw(4 downto 3);
  sg_DeMux_FPD_A <= DeMux_FPD_A          when sw(8) = '1' else sw(5);
  sg_DeMux_FPD_B <= DeMux_FPD_B          when sw(8) = '1' else sw(6);
  sg_DeMux_FPD_C <= DeMux_FPD_C          when sw(8) = '1' else sw(7);
      
  vs_12bit <= '1' when     sg_DeMux_FPD_A = '0' 
                       and sg_DeMux_FPD_B = '1' 
                       and sg_DeMux_FPD_C = '0' else '0';
   
  vs_8bit <= '1' when      sg_DeMux_FPD_A = '1' 
                       and sg_DeMux_FPD_B = '0' 
                       and sg_DeMux_FPD_C = '1' else '0';
    
  cam1_vs12bit <= cam5_d1_cam1_vs when vs_12bit = '1' else '0';
  cam1_vs8bit  <= cam1_d0_cam1_vs when vs_8bit  = '1' else '0'; 
  cam1_vs      <= cam1_vs12bit or cam1_vs8bit;
  
  cam1_d0   <= cam1_d0_cam1_vs   when sg_DeMux_FPD_B = '1' else '0';     
  cam1_d10  <= cam5_d2_cam1_d10  when sg_DeMux_FPD_C = '0' else '0';
  cam1_d11  <= cam5_d3_cam1_d11  when sg_DeMux_FPD_C = '0' else '0';

  li_sel      <= '1' when sg_mux1_sel = "00" and sg_mux2_sel = "01" else '0';
  ov_sel      <= '1' when sg_mux1_sel = "01" and sg_mux2_sel = "01" else '0';
  apt_sel     <= '1' when sg_mux1_sel = "10" and sg_mux2_sel = "01" else '0';
  vi_sel      <= '1' when sg_mux2_sel = "00" else '0';
  
  -- This is a demux not a mux as the spec implies, 1 in 3 out
  reset <= gpio_1_3 and app_bd_porz;
  
  li_cmos_rst <= reset when li_sel  = '1' else '0';
  apt_cam_rst <= reset when apt_sel = '1' else '0';
  vi_reset    <= reset when vi_sel  = '1' else '0';
  
  -- For 8bit modes shift the data down to VIN[7:0]
  -- sw(6)/ sg_DeMux_FPD_B = 0 shift the camera
  cam_shift <= not sg_DeMux_FPD_B;
  --
  --li_cam_d        : in std_logic_vector(13 downto 0 );
  mux_li_data <= "0000"   & li_cam_d(13 downto 4) when  cam_shift = '1' else
                 li_cam_d;
  
  --ov_1y           : in std_logic_vector(9 downto 0 );  
  mux_ov_data <= "000000" & ov_1y(9 downto 2) when cam_shift = '1' else 
                 "0000"   & ov_1y(9 downto 0);
                 
  --apt_cam_bd      : in std_logic_vector(11 downto 0 );
  mux_apt_data <= "000000" & apt_cam_bd(11 downto 4) when cam_shift = '1' else
                  "00"     & apt_cam_bd;  
  
  -- Create MUX 1
  mux1_in1 <=  li_cmos_pclk   & li_vert_sync   & li_hori_sync   & mux_li_data;
  mux1_in2 <=  ov_1plck       & ov_1vsync      & ov_1href       & mux_ov_data;
  mux1_in3 <=  apt_cam_bpxclk & apt_cam_bframe & apt_cam_bline  & mux_apt_data;

  process( sg_mux1_sel,mux1_in1, mux1_in2, mux1_in3)
  begin
  	case  sg_mux1_sel(1 downto 0 ) is
			when "00"         => pro_cam <= mux1_in1;  -- li
			when "01"         => pro_cam <= mux1_in2;  -- ov
			when "10"         => pro_cam <= mux1_in3;  -- apt
			when others       => pro_cam <= (others => 'X');
		end case;		
  end process;
  
  mux_cam_data <=   cam3_dm(9 downto 2) & "000000" 
                        & cam1_d11 & cam1_d10 & cam1_d(9 downto 2)
                    when cam_shift = '1' else 
                    cam3_dm(7 downto 0) & "0000" 
                      & cam1_d11 & cam1_d10 & cam1_d(9 downto 1) & cam1_d0;  
                         
    -- Create MUX 2                                              | 24 bit data lane
  mux2_in1 <=  vi_odck     & vi_vsync    & vi_hsync    & vi_de & vi_qe(23 downto 0);  
  mux2_in2 <=  pro_cam(16) & pro_cam(15) & pro_cam(14) & '0'   & "0000000000" & pro_cam(13 downto 0) ;
  mux2_in3 <=  cam1_pclk   & cam1_vs     & cam1_hs     & '0'   
                           & mux_cam_data;
   
  -- Omni mux1_in2 : mux1_sel(1:0)== "01", mux2_sel(1:0)= "01"
  process( sg_mux2_sel,mux2_in1, mux2_in2, mux2_in3)
  begin
  	case  sg_mux2_sel(1 downto 0 ) is
			when "00"         => mux2_out <= mux2_in1; -- vi
			when "01"         => mux2_out <= mux2_in2; -- pro_cam( mux1_sel:00=li, mux1_sel:01=ov,mux1_sel:10=apt)
			when "10"         => mux2_out <= mux2_in3; -- cam3
			when others       => mux2_out <= (others => 'X');
		end case;		
  end process;
    
  vin1a_clk0      <= mux2_out(27);
  vin1a_vsync     <= mux2_out(26);
  vin1a_hsync     <= mux2_out(25);
  vin1a_de        <= mux2_out(24);
  vin1a_d         <= mux2_out(23 downto 0 );
   
  cam3_vs12bit <= cam6_d1_cam3_vs when vs_12bit = '1' else '0';
  cam3_vs8bit  <= cam3_d0_cam3_vs when vs_8bit  = '1' else '0'; 
  cam3_vs      <= cam3_vs12bit or cam3_vs8bit;
  cam3_d10     <= cam6_d2_cam3_d10  when sg_DeMux_FPD_A = '0' else '0';
  cam3_d11     <= cam6_d3_cam3_d11  when sg_DeMux_FPD_A = '0' else '0';
  cam3_d0      <= cam3_d0_cam3_vs   when sg_DeMux_FPD_B = '1' else '0';
  cam3_dm      <= cam3_d11 & cam3_d10 & cam3_d(9 downto 1) & cam3_d0;
  
  vin2a_d       <= "00" & cam3_dm(11 downto 10) when cam_shift = '1' else
                   cam3_dm(11 downto 8);
  vin1b_clk1    <= cam3_pclk;
  vin2a_d22     <= cam3_hsync;
  vin2a_d23     <= cam3_vs;
   
  --li_sel
  tp(54) <= '1' when sg_mux1_sel = "00" and sg_mux2_sel = "01" else '0';
  --apt_sel
  tp(53) <= '1' when sg_mux1_sel = "10" and sg_mux2_sel = "01" else '0';
  --vi_sel
  tp(52) <= '1' when sg_mux2_sel = "00" else '0';
  
  tp(51) <= reset when li_sel  = '1' else '0';
  tp(50) <= reset when apt_sel = '1' else '0';
  tp(49) <= reset when vi_sel  = '1' else '0';
  
  --tp(54 downto 49) <= (others => 'Z');
  --tp(44 downto 40) <= (others => 'Z');
  tp(44) <= sg_mux1_sel(0);
  tp(43) <= sg_mux1_sel(1);
  tp(42) <= sg_mux2_sel(0);
  tp(41) <= sg_mux2_sel(1);
  tp(40) <= ov_sel;
  
  tp(45) <= mux2_out(0);
  tp(46) <= mux2_out(27);
  tp(47) <= cam3_hsync;
  tp(48) <= cam3_vs;
  
end Behavioral;
