/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fsigraphs.delaymeasurement;

import fileutilities.FileUtilities;
import fsi.FSIRawParser;
import fsiskewcompensationutility.FSISkewCompensationUtility;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;

/**
 * FXML Controller class
 *
 * @author a0225962
 */
public class GraphFSIDelayMeasurement_FXMLController implements Initializable {

    @FXML
    private LineChart<Number, Number> DelayLineChart_LC;
    @FXML
    private TableView<DelayTableItem> DelayTable_TV;
    @FXML
    private TableColumn DelayTap_TC;
    @FXML
    private TableColumn DelayTime_TC;
    

    /**
     * Initializes the controller class.
     */
    @Override
    public void initialize(URL url, ResourceBundle rb) {
        
        if ("".equals(FSISkewCompensationUtility.delayMeasureFilePath))
        {
            File file = FileUtilities.ChooseFile(
                    "Select the delay measurement file", new String[]{ "*"});
            if (file != null)
            {
                FSISkewCompensationUtility.delayMeasureFilePath = file.getAbsolutePath();
            }
        }
        if (!("".equals(FSISkewCompensationUtility.delayMeasureFilePath)))
        {
            double[] delays = 
                        FSIRawParser.GenearateDelayMeasurementArray(FSISkewCompensationUtility.delayMeasureFilePath);

            SetGraph(delays);
            SetTable(delays);
        }
        
    }    
    
    public void SetGraph(double [] delay)
    {
        XYChart.Series series = new XYChart.Series();
        series.setName("Delay");
        for (int i = 0; i < 32; i++)
        {
            series.getData().add(new XYChart.Data<>(i, delay[i]));
        }
        DelayLineChart_LC.getData().add(series);
        
    }
    
    public void SetTable(double [] delay)
    {
        ObservableList<DelayTableItem> data =
        FXCollections.observableArrayList(
        );
        for (int i = 0; i < 32; i++)
        {
            data.add(new DelayTableItem(i, delay[i]));
        }
        DelayTap_TC.setCellValueFactory(
                new PropertyValueFactory<>("delayTap"));
        DelayTime_TC.setCellValueFactory(
                new PropertyValueFactory<>("delayTime"));
        DelayTable_TV.setItems(data);
    }
    
    public class DelayTableItem{
        private final SimpleIntegerProperty delayTap;
        private final SimpleDoubleProperty delayTime;
 
        private DelayTableItem(int tap, double time) {
            this.delayTap = new SimpleIntegerProperty((tap));
            this.delayTime = new SimpleDoubleProperty((time));
        }
        
        public int getDelayTap() {
            return delayTap.get();
        }
 
        public void setDelayTap(int tap) {
            delayTap.set(tap);
        }
        
        
        public double getDelayTime() {
            return delayTime.get();
        }
 
        public void setDelayTime(double time) {
            delayTime.set(time);
        }
    }
    
}
