//--------------------------------------------------------------------------
// dsk6455init.c
//
// Private initialization functions for DSK6455
//
//--------------------------------------------------------------------------
#include <stdio.h>
#include <netmain.h>
#include "dsk6455.h"

// MDIO phy access functions
uint MDIO_phyRegWrite( uint phyIdx, uint phyReg, Uint16 data );
uint MDIO_phyRegRead( uint, uint, UINT16 * );

// This string array corresponds to link state as defined in c6455_mdio.h
static char *LinkStr[] = { "No Link",
                           "10Mb/s Half Duplex",
                           "10Mb/s Full Duplex",
                           "100Mb/s Half Duplex",
                           "100Mb/s Full Duplex",
                           "1000Mb/s Full Duplex" };

static UINT8 bMacAddr[8];

//
// Main Thread
//
// We changed our TCF file to point call this private init
// function. Here we initialize our board and read in our
// MAC address.
//
void c6455_init()
{
    // Init the EVM
    DSK6455_init();
    // Read in EMAC MAC Address
    DSK6455_EEPROM_read(0x00007F00, (Uint32)bMacAddr, 8);
}

//
// C6455EMAC_getConfig()
//
// This is a callback from the Ethernet driver. This function
// is used by the driver to get its 6 byte MAC address, and
// to determine which DSP interrupt the EMAC should be mapped to.
//
void C6455EMAC_getConfig( UINT8 *pMacAddr, uint *pIntVector )
{
    printf("Using MAC Address: %02x-%02x-%02x-%02x-%02x-%02x\n",
            bMacAddr[0], bMacAddr[1], bMacAddr[2],
            bMacAddr[3], bMacAddr[4], bMacAddr[5]);

    // We fill in the two pointers here. We'll use int 5 for EMAC
    mmCopy( pMacAddr, bMacAddr, 6 );
    *pIntVector = 5;
}

//
// C6455EMAC_linkStatus()
//
// This is a callback from the Ethernet driver. This function
// is called whenever there is a change in link state. The
// current PHY and current link state are passed as parameters.
//
void C6455EMAC_linkStatus( uint phy, uint linkStatus )
{
        Uint16 pData;

    printf("Link Status: %s on PHY %d\n",LinkStr[linkStatus],phy);

        MDIO_phyRegRead( phy, 0x2, &pData );

    // Program the LEDs for the Intel phy 
        if (pData ==0x13)
        MDIO_phyRegWrite( phy, 0x14, 0xd5d0 );

    // Program the LEDs for the Broadcom phy 
        if (pData ==0x20)
        MDIO_phyRegWrite( phy, 0x1C, 0xa418 );
}

