/*
 *  ======== main.c ========
 */
#include <xdc/std.h>

#include <ti/sdo/ce/CERuntime.h>
#include <ti/sdo/ce/trace/gt.h>

/* trace info: module name, mask */
static GT_Mask gtMask = {0,0};

/*
 *  ======== main ========
 */
Void main(Int argc, Char *argv[])
{
    
    // Uncomment the following to trap the PC on the dsp side (for debugging)  
/*    
    volatile Int i = 0;
    volatile Int j = 0;

    while (i == 0) {
        i *= j;
    }  
*/
    /* init Codec Engine */
    CERuntime_init();

    /* init trace */
    GT_init();

    /* create a mask to allow a trace-print welcome message below */
    GT_create(&gtMask, "ti.sdo.apps.servers.rotate");

    /* ...and initialize all masks in this module to "on" */
    GT_set("ti.sdo.apps.servers.rotate=01234567");

    /* ... and finally, if an override is passed in via argv[1], set _that_ */
    if (argc > 1 && argv[1] != NULL) {
        GT_set(argv[1]);
    }

    GT_3trace(gtMask, GT_4CLASS, "main> "
        "Welcome to DSP server's main. (argc=%d, argv[0]='%s', argv[1]='%s')\n",
        argc, argv[0], (argc > 1) ? argv[1] : "(null)" );
}


