/*
 *  ======== rotate.c ========
 *  ROTATE API's that leverage IMGDEC API in codec engine to run algorithm 
 *
 *  The methods defined here must be independent of whether the underlying
 *  algorithm is executed locally or remotely.
 *
 */
#include <xdc/std.h>

#include <ti/xdais/ialg.h>
#include <ti/sdo/ce/image/imgdec.h>

#include "rotate.h"

/* Default creation parameters */
ROTATE_Params ROTATE_PARAMS = {
    {sizeof(ROTATE_Params),  /**< Total size of the extended structure */
    0,                     /**< Maximum height. (unused) */
    0,                     /**< Maximum width. (unused) */
    0,                     /**< Maximum number of scans. (unused) */
    0,                     /**< Endianness of output data. (unused) */
    0},                    /**< Force decode in given Chroma format. (unused) */
    {sizeof(IROTATE_Params), /**< size of original algorithm params structure */
    FALSE},                  /**< Bool reverseImage */
    0                        /**< Max image size to be processed */
};

/*
 *  ======== ROTATE_create ========
 */
ROTATE_Handle ROTATE_create(Engine_Handle server, String name,
    ROTATE_Params *params)
{
    if (params == NULL) {
        params = &ROTATE_PARAMS;
    }

    return (IMGDEC_create(server, name, (IMGDEC_Params *)params));
}

/*
 *  ======== ROTATE_delete ========
 */
Void ROTATE_delete(ROTATE_Handle dec)
{
    IMGDEC_delete(dec);
}

/*
 *  ======== ROTATE_process ========
 *  This method must be the same for both local and remote invocation;
 *  Each call is translated into an IMGDEC_process call.
 */
XDAS_Int32 ROTATE_process(ROTATE_Handle handle, char inBuf[],
    char outBuf[], XDAS_Int32 bufSize, XDAS_Int16 cosine,XDAS_Int16 sine)
{
    XDAS_Int32 			retVal = 0;
    ROTATE_InArgs   		inArgs;
    ROTATE_OutArgs 		outArgs;
    XDM_BufDesc 		inBufDesc;
    XDM_BufDesc 		outBufDesc;
    XDAS_Int32                  inBufSizes[1] = {bufSize};
    XDAS_Int8 *                 inBufPtrs[1] = {inBuf};
    XDAS_Int32                  outBufSizes[1] = {bufSize};
    XDAS_Int8 *                 outBufPtrs[1] = {outBuf};

    
    inBufDesc.numBufs = 1;
    outBufDesc.numBufs = 1;
    inBufDesc.bufSizes = inBufSizes;
    outBufDesc.bufSizes = outBufSizes;
    inBufDesc.bufs = inBufPtrs;
    outBufDesc.bufs = outBufPtrs;

    /* 
     * Note the size field MUST be set to the size of the extended argument 
     * structure to ensure the arguments are copied over correctly
     */
    inArgs.iimgdecInArgs.size = sizeof(ROTATE_InArgs);

    inArgs.cosine = cosine;
    inArgs.sine = sine;

    /*      
     * Note the size field MUST be set to the size of the extended argument
     * structure to ensure the arguments are copied over correctly
     */
    outArgs.iimgdecOutArgs.size = sizeof(ROTATE_OutArgs);

    if (handle) {
        retVal = IMGDEC_process((IMGDEC_Handle)handle, &inBufDesc, &outBufDesc,
            (IMGDEC_InArgs *)&inArgs, (IMGDEC_OutArgs *)&outArgs);
    }
    return (retVal);
}


