/*
 * display.h
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2005
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#ifndef _DISPLAY_H
#define _DISPLAY_H

#include <pthread.h>

#include <fifoutil.h>
#include <rendezvous.h>

/* Display thread commands */
#define DISPLAY_FLUSH -1
#define DISPLAY_PRIME -2

typedef struct BufferElement {
    int   id;
    int   width;
    int   height;
    char *frameBuffer;
} BufferElement;

typedef struct DisplayEnv {
    Rendezvous_Handle hRendezvous;
    FifoUtil_Obj      outFifo;
    FifoUtil_Obj      inFifo;
    pthread_mutex_t   prime;
} DisplayEnv;

extern void *displayThrFxn(void *arg);

#endif /* _DISPLAY_H */
