/*
 *  ======== rotate_stubs.c ========
 *  These functions are the "app-side" of a "remote" implementation.
 *
 */
#include <xdc/std.h>
#include <ti/sdo/ce/visa.h>
#include <ti/sdo/ce/osal/Memory.h>

#include "rotate.h"
#include "_rotate.h"

static XDAS_Int32 process(IROTATE_Handle handle, XDAS_Int8 inBuf[], 
        XDAS_Int8 outBuf[], IROTATE_ADAPT_InArgs * inArgs);

IROTATE_ADAPT_Fxns ROTATE_STUBS = {
    {&ROTATE_STUBS, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL},
    process,
};

/*
 *  ======== process ========
 *  This is the stub-implementation for the process method
 */
static XDAS_Int32 process(IROTATE_Handle handle, XDAS_Int8 inBuf[], 
        XDAS_Int8 outBuf[], IROTATE_ADAPT_InArgs * inArgs)
{
    XDAS_Int32 retVal;
    VISA_Handle visa = (VISA_Handle)handle;
    _ROTATE_Msg *msg;

    /* get a message appropriate for this algorithm */
    if ((msg = (_ROTATE_Msg *)VISA_allocMsg(visa)) == NULL) {
        return (ROTATE_ERUNTIME);
    }

    /* Specify the processing command that the skeleton should do */
    msg->visa.cmd = _ROTATE_CPROCESS;

    /* inBuf, y, cr, cb are pointers, so we have to convert them */
    msg->cmd.process.inBuf = (XDAS_Int8 *)
        Memory_getBufferPhysicalAddress(inBuf, inArgs->bufSize, NULL);

    if (msg->cmd.process.inBuf == NULL) {
        retVal = ROTATE_ERUNTIME;
        goto exit;
    }

    /* 
     * Similarly with outBuf. Note that inArgs contain no
     * pointers, so we can simply copy the entire original structure.
     */
    msg->cmd.process.outBuf = (XDAS_Int8 *)
        Memory_getBufferPhysicalAddress(outBuf, inArgs->bufSize, NULL);

    if (msg->cmd.process.outBuf == NULL) {
        retVal = ROTATE_ERUNTIME;
        goto exit;
    }

    /* inArgs has no pointers, so simply copy the struct fields into the msg */
    msg->cmd.process.inArgs = *inArgs;


    /* send the message to the skeleton and wait for completion */
    retVal = VISA_call(visa, (VISA_Msg *)&msg);


    /*
     * Note that we don't have to do any reverse address translation, as the
     * originally provided buffers haven't changed.
     */

exit:
    VISA_freeMsg(visa, (VISA_Msg)msg);

    return (retVal);
}


