/*
 *  ======== rotate_skel.c ========
 *  This file contains the implemenation of the SKEL interface for
 *  ROTATE algorithms.
 *
 *  These functions are the "server-side" of the the stubs defined in
 *  rotate_stubs.c
 */
#include <xdc/std.h>
#include <ti/sdo/ce/skel.h>
#include <ti/sdo/ce/osal/Memory.h>

#include "rotate.h"
#include "_rotate.h"

/*
 *  ======== call ========
 */
static VISA_Status call(VISA_Handle visaHandle, VISA_Msg visaMsg)
{
    _ROTATE_Msg *msg  = (_ROTATE_Msg *)visaMsg;
    ROTATE_Handle handle = (ROTATE_Handle)visaHandle;
    XDAS_Int8 *inBuf;
    XDAS_Int8 *outBuf;

    /* perform the requested ROTATE operation by parsing message. */
    switch (msg->visa.cmd) {

        case _ROTATE_CPROCESS: {
            /* unmarshall inBuf and outBuf */
            inBuf  = msg->cmd.process.inBuf;
            outBuf = msg->cmd.process.outBuf;

            /* invalidate cache for input buffer */
            Memory_cacheInv(inBuf, msg->cmd.process.inArgs.bufSize);

            /* make the process call */
            msg->visa.status = ROTATE_process(handle, (char *)inBuf,  
                (char *)outBuf, msg->cmd.process.inArgs.bufSize, 
                msg->cmd.process.inArgs.cosine, msg->cmd.process.inArgs.sine);

            /* flush cache for output buffer */
            Memory_cacheWbInv(outBuf, msg->cmd.process.inArgs.bufSize);

            /*
             * Note that any changes to individual outBufs[i] values made by
             * the codec will automatically update msg->cmd.process.outBufs
             * as we pass the outBufs array by reference.
             */

            break;
        }

        default: {
            msg->visa.status = VISA_EFAIL;

            break;
        }
    }
    return (VISA_EOK);
}

/*
 *  ======== ROTATE_SKEL ========
 */
SKEL_Fxns ROTATE_SKEL = {
    call,
    (SKEL_CREATEFXN)ROTATE_create,
    (SKEL_DESTROYFXN)ROTATE_delete,
};

