/*
 * ui.h
 *
 * ============================================================================
 * Copyright (c) Texas Instruments Inc 2005
 *
 * Use of this software is controlled by the terms and conditions found in the
 * license agreement under which this software has been supplied or provided.
 * ============================================================================
 */

#ifndef _UI_H
#define _UI_H

#include "rotate_demo.h"

/* How often to poll the msp430 for new IR commands */
#define REMOTECONTROLLATENCY 300000

/* Double buffered OSD window */
#define NUM_BUFS             2

/* Text placements on OSD */
#define COLUMN_1             40
#define COLUMN_2             280
#define COLUMN_3             430

#define ROW_1                yScale(50)
#define ROW_2                yScale(80)
#define ROW_3                yScale(110)
#define ROW_4                yScale(140)
#define ROW_5                yScale(170)
#define ROW_6                yScale(200)

typedef enum BtnIdx {
    BTNIDX_INVALID = -1,
    BTNIDX_CTRL = 0,
    BTNIDX_CTRLPLAY,
    BTNIDX_CTRLPAUSE,
    BTNIDX_CTRLSTOP,
    BTNIDX_NAV,
    BTNIDX_NAVPLUS,
    BTNIDX_NAVMINUS,
    BTNIDX_INFO,
    BTNIDX_WRONG,
    BTNIDX_WRONGPRESSED,
    BTNIDX_NUM
} BtnIdx;

typedef struct UIParams {
    int           imageWidth;
    int           imageHeight;
    int           passThrough;
    char        **osdDisplays;
} UIParams;

/* Global UI functions */
extern void uiClearScreen(int x, int y, int w, int h, int screenIdx);
extern int  uiDrawText(char *string, int x, int y, int screenIdx);
extern int  uiPressButton(BtnIdx btnIdx, int screenIdx);
extern int  uiCreate(UIParams *uiParams);
extern int  uiDelete(void);

#endif /* _UI_H */
