//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

char StatusLED;
int Frequency[5];
int GPIODirection;
int MicrosteppingIndex;
int ABAccelRate, ABDesiredStepperSpeed, ABtmpAccelTimeBase, ABAccelTimeBase, ABAccelerateState, ABStepsToMove;
int CDAccelRate, CDDesiredStepperSpeed, CDtmpAccelTimeBase, CDAccelTimeBase, CDAccelerateState, CDStepsToMove;
bool ABMoveSteps, CDMoveSteps;

void Task0(void)
{
if (MessageComplete)
    {
      SerialOutBuffer[0] = 1;
      SerialOutBuffer[1] = 0;
      SerialOutBuffer[2] = 0;
      switch(OPCODE)
      {
// Write GPIO Data [ OPCODE = 1 ] [ PORT1 DATA ] [ PORT4 DATA ] [ Not Used ] [ Not Used ]
// GPIO DATA = P13/P12/P11/P10/P47/P46/P45/P44
      case (WRITE_GPIO):

            P1OUT = SerialBuffer[1];
            P4OUT = SerialBuffer[2];
            break;
// DAC 0 Config and Write [ OPCODE = 2 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC0_UPDATE):
            DAC12_0CTL = 0;
            DAC12_0CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_0DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
// DAC 1 Config and Write [ OPCODE = 3 ] [ Config HB ] [ Config LB ] [ Data HB ] [ Data LB ]
      case (DAC1_UPDATE):
            DAC12_1CTL = 0;
            DAC12_1CTL = (SerialBuffer[1] * 256) + SerialBuffer[2];
            DAC12_1DAT = (SerialBuffer[3] * 256) + SerialBuffer[4];
            break;
// Pulse Timer Output [ OPCODE = 4 ] [Timer Used] [ Pulse Length Hi ] [ Pulse Length Lo ] [ Not Used ]
      case (PULSE_TMR):
        TBCTL &= ~TB_CNTL_08;                //Configure Timer to run up to FFFF (16 bit FRC)
        switch (SerialBuffer[1])
        {
        case 0:
            TBCCTL0 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL0 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL0 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR0 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 1:
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL1 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR1 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 2:
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL2 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR2 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        case 3:
            TBCCTL3 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL3 |= TB_OUT_HIGH;                                     //Set the output (pulse start)
            TBCCTL3 |= TB_OUTMOD_RESET;                                 //Configure the timer to reset
            TBCCR3 = TBR + ((SerialBuffer[2] * 256) + SerialBuffer[3]); //Configure the pulse reset time (pulse end)
          break;
        }
        break;

// Send DRV8821 SPI [ OPCODE = 5 ] [ Data Hi ] [ Data Lo ] [ ENG MODE ] [ Not Used ]
      case (DRV8821_SEND_SPI):

            P4SEL &= (char)~(DRV8821_SCLK | DRV8821_SDATA | DRV8821_STRB | DRV8821_SCS);          //Configure SPI pins as General Purpose I/O
            P4OUT &= (char)~(DRV8821_SCLK | DRV8821_SDATA | DRV8821_STRB | DRV8821_SCS);         // Clear SPI channel

            int DRV8821_SPI_Data, i;

            P4OUT |= (char)(DRV8821_SCS);
            DRV8821_SPI_Data = (SerialBuffer[1] * 256) + SerialBuffer[2];

            for (i = 0; i<16;i++)
                {
                P4OUT &= ~DRV8821_SCLK;                                       //The clock starts LO. Data is latched on Rising Edge

                if (DRV8821_SPI_Data & 0x0001)                           // Determine if Data Bit is High or Low
                {
                    P4OUT |= DRV8821_SDATA;                                // Write a 1
                }
                else
                {
                    P4OUT &= ~DRV8821_SDATA;                               // Write a 0
                }
                P4OUT |= DRV8821_SCLK;                                      // CLK goes HI. Data is latched

                DRV8821_SPI_Data >>= 1;                                  // Shift Right SPI Data Out Register (MOSI)
                }

            P4OUT &= ~DRV8821_SCLK;
            if (SerialBuffer[3] & 0x01)
                P4OUT |= DRV8821_SDATA;                                // Write a 1
            else
                P4OUT &= ~DRV8821_SDATA;                                // Write a 0

            if (SerialBuffer[3] & 0x02)
            {
             P4OUT |= DRV8821_SCLK;                                      // CLK goes HI. Data is latched
             P4OUT &= ~DRV8821_SCLK;                                       //The clock starts LO. Data is latched on Falling Edge
            }

            P4OUT |= DRV8821_STRB;                                       // Strobe Action
            P4OUT &= ~DRV8821_STRB;

            if (SerialBuffer[3] & 0x01)
            {
                for (i = 0; i <16; i++)
                {
                    P4OUT |= DRV8821_SCLK;                                      // CLK goes HI. Data is latched
                    P4OUT &= ~DRV8821_SCLK;                                       //The clock starts LO. Data is latched on Falling Edge
                }
            }

            P4OUT &= ~ (DRV8821_SCLK | DRV8821_SDATA | DRV8821_STRB | DRV8821_SCS);         // Clear SPI channel
            P4SEL |= (char) (DRV8821_SCLK | DRV8821_SDATA | DRV8821_STRB | DRV8821_SCS);          //Configure SPI pins as General Purpose I/O
        break;

// START STEPPER AB[ OPCODE = 6 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (START_STEPPER_AB):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            ABDesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            ABAccelRate = SerialBuffer[3];
            ABAccelTimeBase = SerialBuffer[4];
            ABtmpAccelTimeBase = ABAccelTimeBase;
            Frequency[ABSTEP_TIMER_NUMBER] = 0xFFFF;                                       //Slowest Startup Speed
            TBCCR1 = Frequency[ABSTEP_TIMER_NUMBER];
            ABAccelerateState = ACCEL;
        break;
// STOP STEPPER AB[ OPCODE = 7 ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ] [ Not Used ]
      case (STOP_STEPPER_AB):
            ABAccelerateState = STOP;
            ABDesiredStepperSpeed = 0xFF00;                               //Speed to stop at
            ABtmpAccelTimeBase = ABAccelTimeBase;
      break;
// STEPPER_SPEED AB[ OPCODE = 8 ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (STEPPER_SPEED_AB):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            ABDesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            ABAccelRate = SerialBuffer[3];
            ABAccelTimeBase = SerialBuffer[4];
            ABtmpAccelTimeBase = ABAccelTimeBase;
            if ((unsigned int)ABDesiredStepperSpeed < (unsigned int)Frequency[ABSTEP_TIMER_NUMBER])
            {
                ABAccelerateState = ACCEL;
            }
            else
            {
                ABAccelerateState = DECEL;
            }
      break;
// MOVE_STEPS AB[ OPCODE = 9 ] [ Frequency Hi ] [ Frequency Lo ] [ STEPS Hi ] [ STEPS Lo ]
      case (MOVE_STEPS_AB):
            TBCCTL1 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL1 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[ABSTEP_TIMER_NUMBER] = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            ABStepsToMove = (SerialBuffer[3] * 256) + SerialBuffer[4];   //Configure the Frequency Rate
            TBCCR1 = Frequency[ABSTEP_TIMER_NUMBER];
            ABMoveSteps = true;
            break;

// START STEPPER CD[ OPCODE = A ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (START_STEPPER_CD):
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            CDDesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            CDAccelRate = SerialBuffer[3];
            CDAccelTimeBase = SerialBuffer[4];
            CDtmpAccelTimeBase = CDAccelTimeBase;
            Frequency[CDSTEP_TIMER_NUMBER] = 0xFFFF;                                       //Slowest Startup Speed
            TBCCR2 = Frequency[CDSTEP_TIMER_NUMBER];
            CDAccelerateState = ACCEL;
        break;
// STOP STEPPER CD[ OPCODE = B ] [ Frequency Hi ] [ Frequency Lo ] [ Not Used ] [ Not Used ]
      case (STOP_STEPPER_CD):
            CDAccelerateState = STOP;
            CDDesiredStepperSpeed = 0xFF00;                               //Speed to stop at
            CDtmpAccelTimeBase = CDAccelTimeBase;
      break;
// STEPPER_SPEED CD[ OPCODE = C ] [ Frequency Hi ] [ Frequency Lo ] [ Accel Rate ] [ Accel Time Base ]
      case (STEPPER_SPEED_CD):
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            CDDesiredStepperSpeed = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            CDAccelRate = SerialBuffer[3];
            CDAccelTimeBase = SerialBuffer[4];
            CDtmpAccelTimeBase = CDAccelTimeBase;
            if ((unsigned int)CDDesiredStepperSpeed < (unsigned int)Frequency[CDSTEP_TIMER_NUMBER])
            {
                CDAccelerateState = ACCEL;
            }
            else
            {
                CDAccelerateState = DECEL;
            }
      break;
// MOVE_STEPS CD[ OPCODE = D ] [ Frequency Hi ] [ Frequency Lo ] [ STEPS Hi ] [ STEPS Lo ]
      case (MOVE_STEPS_CD):
            TBCCTL2 &= 0xFF1F;                                          // Clear OUTMODx bits; 3 MSB on lower byte; Timer configured to output mode
            TBCCTL2 |= TB_OUTMOD_TOGGLE + CCIE;                         //Configure the timer to reset
            Frequency[CDSTEP_TIMER_NUMBER] = (SerialBuffer[1] * 256) + SerialBuffer[2];   //Configure the Frequency Rate
            CDStepsToMove = (SerialBuffer[3] * 256) + SerialBuffer[4];   //Configure the Frequency Rate
            TBCCR2 = Frequency[CDSTEP_TIMER_NUMBER];
            CDMoveSteps = true;
            break;

// Read Memory [Opcode = 0xE0 ] [ Address Hi ] [ Address Lo ] [ Not Used ] [ Not Used ]
      case (READ_MEM):
       int * MyPointer;
       int Address;

       Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
       MyPointer = (int *) Address;
       SerialOutBuffer[1] = (*MyPointer & 0xFF00) >> 8;
       SerialOutBuffer[2] = (*MyPointer & 0xFF);
      break;
// Write Memory [Opcode = 0xE1 ] [ Address Hi ] [ Address Lo ] [ Data Hi ] [ Data Lo ]
      case (WRITE_WMEM):
        int Data;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        Data = (SerialBuffer[3]*256 + SerialBuffer[4]);
        MyPointer = (int *) Address;
        *MyPointer = Data;
        break;

// Write Byte Memory [Opcode = 0xE2 ] [ Address ] [ Address Lo ] [ Data ] [Not Used ]
      case (WRITE_BMEM):
        char BData;
        char * MyPtr;

        Address = (SerialBuffer[1]*256 + SerialBuffer[2]);
        BData = SerialBuffer[3];
        MyPtr = (char *) Address;
        *MyPtr = BData;
        break;

      case (RESET_MCU):
        WDTCTL = 0x00;
        break;
      case (SHOW_CLKS):
        P5SEL |= SerialBuffer[1] & 0xF0;
        break;
      }
    MessageComplete = false;
    SerialOutPointer = 0;
    TXBUF0 = SerialOutBuffer[SerialOutPointer];
    IE1 |= UTXIE0;
    }
}





