//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
//***********************************************************************************
// App Extern Globals                                                               *
//***********************************************************************************
extern int Frequency[5];
extern int MicrosteppingIndex;
extern int ABAccelRate, ABDesiredStepperSpeed, ABtmpAccelTimeBase, ABAccelTimeBase, ABAccelerateState, ABStepsToMove;
extern int CDAccelRate, CDDesiredStepperSpeed, CDtmpAccelTimeBase, CDAccelTimeBase, CDAccelerateState, CDStepsToMove;
extern bool ABMoveSteps, CDMoveSteps;
//***********************************************************************************
// Firmware Revision                                                                *
//***********************************************************************************
#define     FIRMWARE_REVISION   1
//***********************************************************************************
// Application Specific Hardware Definitions                                        *
//***********************************************************************************
#define     StatusLEDPin    0x20
#define     SPI_MISO        (0x04)      //PORT5.2 //DataIN
#define     SPI_MOSI        (0x02)      //PORT5.1 //Data_AB
#define     SPI_CLK         (0x08)      //PORT5.3
#define     SLAVE_SEL       (0x01)      //PORT5.0
#define     DRV8821_SDATA   (0x40)      //PORT4.6
#define     DRV8821_SCLK    (0x04)      //PORT4.2
#define     DRV8821_STRB    (0x10)      //PORT4.0
#define     DRV8821_SCS     (0x02)      //PORT4.1
#define     DEV_SELECT      (0x20)      //PORT5.5

#define     P1OUT_INIT  0
#define     P2OUT_INIT  0
#define     P3OUT_INIT  0
#define     P4OUT_INIT  0
#define     P5OUT_INIT  0
#define     P6OUT_INIT  0

//***********************************************************************************
// Application Specific Definitions                                                 *
//***********************************************************************************
#define     OPCODE      SerialBuffer[0]

#define     DRV8821         0x00
#define     DRV8823         0x01

#define     NOACC       0
#define     ACCEL       1
#define     DECEL       2
#define     STOP        3

#define     ABSTEP_TIMER_NUMBER   1
#define     CDSTEP_TIMER_NUMBER   2
//***********************************************************************************
// Application Specific Opcodes                                                     *
//***********************************************************************************
#define     WRITE_GPIO          0x01
#define     DAC0_UPDATE         0x02
#define     DAC1_UPDATE         0x03
#define     PULSE_TMR           0x04
#define     DRV8821_SEND_SPI    0x05
#define     START_STEPPER_AB    0x06
#define     STOP_STEPPER_AB     0x07
#define     STEPPER_SPEED_AB    0x08
#define     MOVE_STEPS_AB       0x09
#define     START_STEPPER_CD    0x0A
#define     STOP_STEPPER_CD     0x0B
#define     STEPPER_SPEED_CD    0x0C
#define     MOVE_STEPS_CD       0x0D

//Memory Access Opcodes
#define     READ_MEM        0xE0
#define     WRITE_WMEM      0xE1
#define     WRITE_BMEM      0xE2

// System Opcodes
#define     RESET_MCU       0xF1
#define     SHOW_CLKS       0xF2

//***********************************************************************************
// Application Specific Externs                                                     *
//***********************************************************************************

extern char StatusLED;
