//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

void Task1(void)
{

  switch (ABAccelerateState)
  {
  case (NOACC):
    break;
  case (ACCEL):
    if (ABtmpAccelTimeBase > 0)
        {
        ABtmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if ((unsigned int) Frequency[ABSTEP_TIMER_NUMBER] < (unsigned int)ABDesiredStepperSpeed)
        {
          Frequency[ABSTEP_TIMER_NUMBER] = ABDesiredStepperSpeed;
          ABAccelerateState = NOACC;
        }
        else
        {
          Frequency[ABSTEP_TIMER_NUMBER] -= ABAccelRate;
        }
        ABtmpAccelTimeBase = ABAccelTimeBase;
        }
    break;

  case (DECEL):
    if (ABtmpAccelTimeBase > 0)
        {
        ABtmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[ABSTEP_TIMER_NUMBER] + (unsigned int) ABAccelRate) < ABDesiredStepperSpeed)
        {
          Frequency[ABSTEP_TIMER_NUMBER] += ABAccelRate;
        }
        else
        {
          ABAccelerateState = NOACC;
        }
        ABtmpAccelTimeBase = ABAccelTimeBase;
        }
    break;

  case (STOP):
    if (ABtmpAccelTimeBase > 0)
        {
        ABtmpAccelTimeBase -= 1;                  //Wait until delay expires
        }
    else
        {
        if (((unsigned int) Frequency[ABSTEP_TIMER_NUMBER] + (unsigned int) ABAccelRate) < ABDesiredStepperSpeed)
        {
          Frequency[ABSTEP_TIMER_NUMBER] += ABAccelRate;
        }
        else
        {
          TBCCTL1 &= 0xFF0F;                                          //Disable CC and Interrupt
          ABAccelerateState = NOACC;
        }
        ABtmpAccelTimeBase = ABAccelTimeBase;
        }
    break;
  }
}
