//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
#include "Config.h"

int main()
{
// Basic Clock Control Registers
DCOCTL = DCO_CONF + MOD_CONF;
BCSCTL1 = XT2OFF_CONF + XTS_CONF + DIVA_CONF + RSEL_CONF;
BCSCTL2 = SELM_CONF + DIVM_CONF + SELS_CONF + DIVS_CONF + DCOR_CONF;

// Ports 1 through 2 Direction Select
P1DIR = (P1DIR7 << 7) + (P1DIR6 << 6) + (P1DIR5 << 5) + (P1DIR4 << 4) + (P1DIR3 << 3) + (P1DIR2 << 2) + (P1DIR1 << 1) + P1DIR0;
P2DIR = (P2DIR7 << 7) + (P2DIR6 << 6) + (P2DIR5 << 5) + (P2DIR4 << 4) + (P2DIR3 << 3) + (P2DIR2 << 2) + (P2DIR1 << 1) + P2DIR0;
P3DIR = (P3DIR7 << 7) + (P3DIR6 << 6) + (P3DIR5 << 5) + (P3DIR4 << 4) + (P3DIR3 << 3) + (P3DIR2 << 2) + (P3DIR1 << 1) + P3DIR0;

// Ports 1 through 2 Alternate Peripheral Function Enable
P1SEL = (P1SEL7 << 7) + (P1SEL6 << 6) + (P1SEL5 << 5) + (P1SEL4 << 4) + (P1SEL3 << 3) + (P1SEL2 << 2) + (P1SEL1 << 1) + P1SEL0;
P2SEL = (P2SEL7 << 7) + (P2SEL6 << 6) + (P2SEL5 << 5) + (P2SEL4 << 4) + (P2SEL3 << 3) + (P2SEL2 << 2) + (P2SEL1 << 1) + P2SEL0;
P3SEL = (P3SEL7 << 7) + (P3SEL6 << 6) + (P3SEL5 << 5) + (P3SEL4 << 4) + (P3SEL3 << 3) + (P3SEL2 << 2) + (P3SEL1 << 1) + P3SEL0;

// Ports 1 and 2 Pin On Change Interrupt Enable
P1IE = (P1IE7 << 7) + (P1IE6 << 6) + (P1IE5 << 5) + (P1IE4 << 4) + (P1IE3 << 3) + (P1IE2 << 2) + (P1IE1 << 1) + P1IE0;
P2IE = (P2IE7 << 7) + (P2IE6 << 6) + (P2IE5 << 5) + (P2IE4 << 4) + (P2IE3 << 3) + (P2IE2 << 2) + (P2IE1 << 1) + P2IE0;
P1IES = (P1IES7 << 7) + (P1IES6 << 6) + (P1IES5 << 5) + (P1IES4 << 4) + (P1IES3 << 3) + (P1IES2 << 2) + (P1IES1 << 1) + P1IES0;
P2IES = (P2IES7 << 7) + (P2IES6 << 6) + (P2IES5 << 5) + (P2IES4 << 4) + (P2IES3 << 3) + (P2IES2 << 2) + (P2IES1 << 1) + P2IES0;

P1IFG = 0;
P2IFG = 0;
IFG2 &= ~UTXIFG0;
UCTL0 &= ~SWRST;                          // Initialize USART state machine

// Interrupt Enable Register 1 and 2
IE1 = (WDTIEEN & WDTIE) + (OFIEEN & OFIE) + (NMIIEEN & NMIIE) + (ACCVIEEN & ACCVIE);
IE2 = (URXIE0EN & URXIE0) + (UTXIE0EN & UTXIE0);

// Module Enable Register 1 and 2
ME2 = (URXE0EN & URXE0) + (UTXE0EN & UTXE0) + (USPIE0EN & USPIE0);

// USART Control Register
U0CTL = PENA0_CONF + PEV0_CONF + SPB0_CONF + CHAR0_CONF + LISTEN0_CONF + SYNC0_CONF + MM0_CONF + SWRST0_CONF;

// USART Transmit Control Register
U0TCTL = CKPL0_CONF + SSEL0_CONF + URXSE0_CONF + TXWAKE0_CONF;

// USART Receive Control Register
U0RCTL = URXEIE0_CONF + URXWIE0_CONF;

// USART BAUD Rate Control Register
UBR00 = BAUD_RATE0_LO;
UBR10 = BAUD_RATE0_HI;
UMCTL0 = BAUD_RATE0_MOD;

// Watchdog Timer Control Register
WDTCTL = WDTPW + WDTHOLD_CONF + WDTNMIES_CONF + WDTNMI_CONF + WDTTMSEL_CONF + WDTCNTCL_CONF + WDTSSEL_CONF + WDTIS_CONF;

// Timer A Configuration
TACTL = TASSEL_CONF + TA_ID_CONF + TAIE_CONF; //TA_MC_CONF occurs below in order to start Tasks after Init
TACCTL0 = TA_CM0_CONF + TA_CCIS0_CONF + TA_SCS0_CONF + TA_CAP0_CONF + TA_OUTMOD0_CONF + TA_CCIE0_CONF + TA_OUT0_CONF;
TACCTL1 = TA_CM1_CONF + TA_CCIS1_CONF + TA_SCS1_CONF + TA_CAP1_CONF + TA_OUTMOD1_CONF + TA_CCIE1_CONF + TA_OUT1_CONF;
TACCTL2 = TA_CM2_CONF + TA_CCIS2_CONF + TA_SCS2_CONF + TA_CAP2_CONF + TA_OUTMOD2_CONF + TA_CCIE2_CONF + TA_OUT2_CONF;

// Digital to Analog Converter Configuration

ADC10CTL0 = SREF_CONF + ADC10SHT_CONF + ADC10SR_CONF + REFOUT_CONF + REFBURST_CONF + MSC_CONF + REF2P5V_CONF + REFON_CONF + ADC10ON_CONF + ADC10IE_CONF + ENC_CONF + ADC10SC_CONF;
ADC10CTL1 = INCH_CONF + SHS_CONF + ADC10DF_CONF + ISSH_CONF + ADC10DIV_CONF + ADC10SSEL_CONF + CONSEQ_CONF;
ADC10AE = (ADC10AE7_EN << 7) + (ADC10AE6_EN << 6) + (ADC10AE5_EN << 5) + (ADC10AE4_EN << 4) + (ADC10AE3_EN << 3) + (ADC10AE2_EN << 2) + (ADC10AE1_EN << 1) + ADC10AE0_EN;
ADC10DTC0 = ADC10TB_CONF + ADC10CT_CONF + ADC10B1_CONF;

TACCR0 = 0xFF;
SerialPointer = 0;
TACTL |= TA_MC_CONF;                        // Timer A Counter Starts as configured
__bis_SR_register(GIE);                     // Enable all Interrupts

//Application Specific Initialization
#include "AppSpecific.h"

__low_power_mode_0();

}


