/************************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
*************************************************************/

/************************************************************/
/* FILENAME: main.c                            				*/
/* DESCRIPTION: This program uses McBSP1 to write sine 		*/
/*	values continuously to the DAC8534 16-bit Digital-to    */
/* -Analog Converter.  The sine values are stored in        */
/* 	the buffer called Sinetable, then sent to the DAC8534. 	*/
/* AUTHOR	: DAP Application Group, T. Hendrick, Dallas    */
/*    CREATED 2003(C) BY TEXAS INSTRUMENTS INCORPORATED.  	*/
/* VERSION: 1.0, Created/Compiled on CCS V2.20 for 6711DSK  */
/************************************************************/

/*Note - JP1 on the DSK MUST be CLOSED to use this program! */

/* Header file */
#include "DAC8534cfg.h"
#include "csl.h"
#include "csl_irq.h"
#include "csl_mcbsp.h"
#include "csl_timer.h"
#include <math.h>

/* DAC Configuration Header file */
#include "DAC8534CMD.h"

/*Declarations*/
#define SINE_TABLE_SIZE  256
#define PI               ((double)3.1415927)
#define SINE_MAX         65535/2
#define N                16

/*Global variables*/
volatile Uint16 sinetable[SINE_TABLE_SIZE];
int z = 0;


/******************************************************************************\
* Function: InitSineTable()
* Description: Initializes Sine Values 
\******************************************************************************/

void InitSineTable(void)
{         
	int y;
	double increment= 0;
	double radian = 0;
	
	increment = (PI * 2) / SINE_TABLE_SIZE; 	
	for (y = 0; y < SINE_TABLE_SIZE; y++)
	{
	    sinetable[y] = (int)((sin(radian)+1) * SINE_MAX) & 0xFFFF;
	    radian += increment;
	}	                                  
}

/******************************************************************************\
* Function: main()
* Description: Enables McBSP1 transmit interrupt
\******************************************************************************/
void main()
{
    InitSineTable();

    MCBSP_start(hMcbsp1, MCBSP_XMIT_START | MCBSP_SRGR_START| MCBSP_SRGR_FRAMESYNC, 0);
	IRQ_enable(IRQ_EVT_XINT1);
}

/******************************************************************************\
* Function: McBSP1Xmt()
* Description: McBSP1 Transmit Interrupt Service Routine.  Write sine values  
* 	out to DAC8534.  Must include DAC Commands (see DAC8534CMD.h)!
\******************************************************************************/
void McBSP1Xmt(void)
{
		for (z=0; z<SINE_TABLE_SIZE; z++)
			{		
	    	/* Wait until a value is received then write it */
	    	while (!MCBSP_xrdy(hMcbsp1));           
	    	MCBSP_write(hMcbsp1, sinetable[z]|DAC_CFG);
		} 
}

/******************************************************************************\
* End of main.c
\******************************************************************************/

