/************************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
*************************************************************/

/************************************************************/
/* FILENAME: main.c                            				*/
/* DESCRIPTION: This program uses McBSP1 to write sine 		*/
/*	values continuously to the DAC8534 16-bit Digital-to    */
/* -Analog Converter.  The sine values are stored in        */
/* 	the buffer called Sinetable, then sent to the DAC8534. 	*/
/* AUTHOR	: DAP Application Group, T. Hendrick, Dallas    */
/*    CREATED 2003(C) BY TEXAS INSTRUMENTS INCORPORATED.  	*/
/* VERSION: 1.0, Created/Compiled on CCS V2.20 for 6713DSK  */
/************************************************************/

/* Header file */
#include "DAC8534cfg.h"
#include "csl.h"
#include "csl_irq.h"
#include "csl_mcbsp.h"
#include "csl_timer.h"
#include "dsk6713.h"
#include <math.h>

/* DAC Configuration Header file */
#include "DAC8534CMD.h"

/*Declarations*/
#define TABLE_SIZE  256
#define PI               ((double)3.1415927)
#define MAX         65535/2
#define N                16

/*Global variables*/
volatile Uint16 sinetable[TABLE_SIZE];
volatile Uint16 costable[TABLE_SIZE];

void McBSP1Xmt(void);

/******************************************************************************\
* Function: InitTables()
* Description: Initializes Sine Values 
\******************************************************************************/

void InitTables(void)
{         
	int y;
	double increment= 0;
	double radian = 0;
	
	increment = (PI * 2) / TABLE_SIZE; 	
	for (y = 0; y < TABLE_SIZE; y++)
	{
	    sinetable[y] = (int)((sin(radian)+1) * MAX) & 0xFFFF;
	    costable[y] = (int)((cos(radian)+1) * MAX) & 0xFFFF;
	    radian += increment;
	}	                                  
}

/******************************************************************************\
* Function: delay()
* Description: Variable delay 
\******************************************************************************/

void delay(int time)
{   int t;
	for(t=0; t<time; t++);
}

/******************************************************************************\
* Function: main()
* Description: Enables McBSP1 transmit interrupt
\******************************************************************************/
void main()
{
    /* Call BSL init */
    DSK6713_init();
    DSK6713_rset(DSK6713_MISC, 0x03); //NOTE - McBSP 2 is on HPI Conn!

    InitTables();

    MCBSP_start(hMcbsp1, MCBSP_XMIT_START | MCBSP_SRGR_START| MCBSP_SRGR_FRAMESYNC, 0);
	IRQ_enable(IRQ_EVT_XINT1);
}

/******************************************************************************\
* Function: McBSP1Xmt()
* Description: McBSP1 Transmit Interrupt Service Routine.  Write sine table out  
* 	to the DAC8534.  Must include DAC Commands (see DAC8534CMD.h)!
\******************************************************************************/
void McBSP1Xmt(void)
{
int z;
		for (z=0; z<TABLE_SIZE; z++)
		{		
			while (!MCBSP_xrdy(hMcbsp1));           
	    	MCBSP_write(hMcbsp1, costable[z]|0x000000);
	    	delay(0);
			while (!MCBSP_xrdy(hMcbsp1));           
	    	MCBSP_write(hMcbsp1, sinetable[z]|0x020000);
	    	delay(0);
			while (!MCBSP_xrdy(hMcbsp1));           
	    	MCBSP_write(hMcbsp1, costable[z]|0x040000);
	    	delay(0);				
			while (!MCBSP_xrdy(hMcbsp1));           
	    	MCBSP_write(hMcbsp1, sinetable[z]|0x260000);
		} 
}

/******************************************************************************\
* End of main.c
\******************************************************************************/

