/****************************************************************/
/*	File: functions.c											*/
/* 	Description: Functions for interfacing ADS7881 to C6713		*/
/*  init_dsk, hwiDMA_isr, swiEnablePrephFunc                    */ 
/* AD converter address: CE2 memory space 						*/
/*						 0xA0014000 (RD#)                     	*/
/*						 0xA0004000 (RESET#)  					*/
/* Hardware Connections:										*/
/* 	CS# => LOW												*/
/*	RD# => Generated from 3-8 decoder mapped to 0xA0014000		*/
/*	CONVST# => Generated is Timer1*/
/*	RESET# => Generated from 3-8  decoder mapped at 0xA0004000	*/
/*	BUSY => Inverted then wired to EXTERNAL INT7				*/
/* AUTHOR	: DAP Application Group, L. Philipose, Dallas   	*/
/*    CREATED 2005(C) BY TEXAS INSTRUMENTS INCORPORATED.  		*/
/* VERSION: 1.0 							                	*/
/****************************************************************/
/*  Include Header File  */
#include "Configcfg.h"
#include "dc_conf.h" 
#include <csl_legacy.h>
int pingpong=0; /*=1 pingbuffer full*/
extern unsigned short ad_data[BLOCK_SZ];
extern unsigned short pingBuf[BLOCK_SZ];
extern unsigned short pongBuf[BLOCK_SZ];
extern unsigned short dataPing[BLOCK_SZ];
extern unsigned short dataPong[BLOCK_SZ];

/****************************************************************/
/* init_dsk()                                                   */
/* This initializes the EMIF                                    */
/****************************************************************/
void init_dsk(void)
{                          
    UINT32 gblctl,ce0ctl,ce1ctl,ce2ctl,ce3ctl,sdctl,sdtim,sdext;

    /* intialization of the EMIF */
    
    /* RBTR8,SSCRT,CLK2EN,CLK1EN,SSCEN,SDCEN,NOHOLD       */
    gblctl = EMIF_MK_GBLCTL( 0, 0, 1, 0, 0, 0, 0);

    /* RDHLD,MTYPE,RDSTRB,TA,RDSETUP,WRHLD,WRSTRB,WRSETUP */
    ce0ctl = EMIF_MK_CECTL( 0, 3, 0, 0, 0, 0, 0, 0);

    /* RDHLD,MTYPE,RDSTRB,TA,RDSETUP,WRHLD,WRSTRB,WRSETUP */
    ce1ctl = EMIF_MK_CECTL( 0, 2, 0, 0, 0, 0, 0, 0);

    /* RDHLD,MTYPE,RDSTRB,TA,RDSETUP,WRHLD,WRSTRB,WRSETUP */
    ce3ctl = EMIF_MK_CECTL( 0, 2, 0, 0, 0, 0, 0, 0);

    /* TRC,TRP,TRCD,INIT,RFEN,SDWID,SDCSZ,SDRSZ,SDBSZ     */ 
    sdctl = EMIF_MK_SDCTL( 7, 1, 1, 1, 1, 0, 1, 0, 0);

    /* PERIOD,XRFR */
    sdtim = EMIF_MK_SDTIM(   1562,   0);

    sdext = EMIF_SDEXT_NA;

    /* make CE2 control register value                    */
    /* This is the CE space used by the ADS8402 EVM.      */
    /* Use the timing values from dc_conf.h:              */
    ce2ctl = EMIF_MK_CECTL(
        EMIF_CECTL_RDHLD_OF   (RDHLD),     /* read  hold   */
        EMIF_CECTL_MTYPE_ASYNC32,
        EMIF_CECTL_RDSTRB_OF  (RDSTRB),    /* read  strobe */
        EMIF_CECTL_TA_NA,
        EMIF_CECTL_RDSETUP_OF (RDSETUP),   /* read  setup  */
        EMIF_CECTL_WRHLD_OF   (WRHLD),     /* write hold   */
        EMIF_CECTL_WRSTRB_OF  (WRSTRB),    /* write strobe */
        EMIF_CECTL_WRSETUP_OF (WRSETUP)    /* write setup  */
    );

    /* configure the EMIF */
    EMIF_ConfigB(gblctl,ce0ctl,ce1ctl,ce2ctl,
        ce3ctl,sdctl,sdtim,sdext);  

    return;
} /* end init_dsk() */


/************************************************************/
/*hwiDMA_isr():												*/
/* 	Hardware Interrupt Function disables EDMA channels and 	*/
/*	Timer0, Then post software interrupt.					*/
/************************************************************/
void hwiDMA_isr()
{ 	int i;
 	   
   if (pingpong==1){
		EDMA_disableChannel(hEdmaCha7); /*Disable EMDA channel 7 -RD#*/
		TIMER_pause(hTimer1);
		for(i=0;i<BLOCK_SZ;i++){
			dataPing[i]=(pingBuf[i] & 0x3FFC)>>2;	
			dataPong[i]=(pongBuf[i] & 0x3FFC)>>2;	//ADS7881 12-bit word		
		}
	}
	pingpong++;

 	IRQ_reset(IRQ_EVT_EDMAINT);					/*Reset EDMA interrupt 		*/
 	IRQ_enable(IRQ_EVT_EDMAINT);
    EDMA_intDisable(TCCINTNUM6);				/*Disable EDMA interrupt 	*/
  	EDMA_intClear(TCCINTNUM6);					/*Clear EDMA interrupt 		*/
  	EDMA_intEnable(TCCINTNUM6);      			/*Enable EDMA interrupt		*/                             				

 
}



/****************************************************************/
/* End Functions.c                                              */
/****************************************************************/
