************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 1998, (C) Copyright 1998, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE : February, 2000
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
*
***********************************************************************
*
*   NOTE:
*   The following files must be present to use this SPICE model:
*      LVC1GU04INC.INC     (netlist)
*      ASL3C5Ninc.inc     (Nominal process models)
*      ASL3C5Sinc.inc     (Strong process models) 	
*      ASL3C5Winc.inc     (Weak    process models)
*      READ.ME            (General use, release notes, ...)
*
*   INSTRUCTIONS:
*   For the process model use either the strong (ASL3C5SINC)
*				     the weak   (ASL3C5WINC)
*				     the nominal(ASL3C5NINC) 	 	
*   To use this SPICE model, include the following lines in your main netlist:
*      (Choose only one package model and one process model)
*      .
*      .
*      .
*       .OPTIONS search='./'
        X_DEVICE_SELECTOR  0 LVC1GU04INC
        X_PROCESS_SELECTOR 0 ASL3C5NINC
*       X_PROCESS_SELECTOR 0 ASL3C5SINC
*       X_PROCESS_SELECTOR 0 ASL3C5WINC
	.include sot5
***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************

xlvc1gu04  x_a1 x_y1 x_vcc x_gnd lvc1gu04 


***********************************************************************
******Supply Voltages
***********************************************************************

v_vcc          x_vcc      0     DC    3.3
v_gnd          x_gnd      0     DC    0.0

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.SUBCKT lvc1gu04 p_a1 p_y1 p_vcc p_gnd 

 X_PIN2       p_a1           s_a1		SOT5_02
 X_PIN4       p_y1           s_y1       	SOT5_04
 X_PIN5       p_vcc          s_vcc              SOT5_05
 X_PIN3       p_gnd          s_gnd              SOT5_03
xlvc1gu04bit  s_a1 s_y1 s_vcc s_gnd lvc1gu04_bit 
.ENDs lvc1gu04
***********************************************************************
.END
                                         




