******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for RC4580
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2007, (C) COPYRIGHT 2007, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

.param pcard = 1
.param pcard_base_resistivity = 0
.param pcard_epi_resistivity = 0
.PARAM PCARD_HSR = 1.0
.PARAM PCARD_BASE = 1.0
.PARAM PCARD_EMIT = 1.0

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'rc4580.inc'
X__RC4580 XOUT1 XINN1 XINP1 XVCCN XINP2 XINN2 XOUT2 XVCCP RC4580

***********************************
*       DC power supplies         *
***********************************
VVCC    xvccp     0  dc   15V
VGND    xvccn     0  dc  -15V
*
***********************************
*          Output Loads           *
***********************************
Rloada  XOUT1  0  2k
Rloadb  XOUT2  0  2k

Cloada  XOUT1  0  50pF
Cloadb  XOUT2  0  50pF
*
***********************************
*         Control Signals         *
***********************************
*
Vinpos1  XINP1     0  pwl  0 0 20us 0 20.01us 1 40.01us 1 40.02us 0 60.02us 0
*
*
*
*
***********************************
*      Special test hookups       *
***********************************
*
Rshort  XOUT1  XINN1  10K
Rinn    XINN1   0    1K
Rinb    XOUT2   XINN2  .0001
Vinposb  XINP2   0   DC 0V 
*
***********************************
*         SPICE Control           *
***********************************
*
.temp 25
.tran 1ns 60us          
*
***********************************
*         SPICE output            *
***********************************
*
.print tran v(XOUT1)



* RESISTORS TO PREVENT DANGLING NODES
R1G_1 XOUT1 0 1G
R1G_2 XINN1 0 1G
R1G_3 XINP1 0 1G
R1G_4 XVCCN 0 1G
R1G_5 XINP2 0 1G
R1G_6 XINN2 0 1G
R1G_7 XOUT2 0 1G
R1G_8 XVCCP 0 1G

.END
