clear; clc; close all; set(0,'DefaultFigureWindowStyle','docked');
format long

%% EQUATIONS
syms B1 B2 B3 B4 B5
syms V1 V2 V3 V4 V5

V1 = 0; V2 = 0;

%First round of substitution
V3 = B3/5 + 2*(V2+V4)/5;
V4 = solve(V4 == B4/5 + 2*(V3+V5)/5, V4);
V5 = solve(V5 == B5/4 + V4/2, V5);

%Back substitution
V4 = subs(V4);
V3 = subs(V3);

V = [V1,V2,V3,V4,V5];
B = [B1,B2,B3,B4,B5];

A = equationsToMatrix(V, B);

%% ITERATION
Rof = zeros(2^5,1); I = Rof; i = 0; %Allocate space and reset counter

%Loop through all code possibilities
for B1  = 0:1
for B2  = 0:1
for B3  = 0:1
for B4  = 0:1
for B5  = 0:1
    i = i + 1;
    B = [B1,B2,B3,B4,B5]';
    X = A*B;
    I1 = 2*B(1)/2;
    I2 = B(2)/2;
    I3 = B(3)*(B(3)-X(3))/2;
    I4 = B(4)*(B(4)-X(4))/2;
    I5 = B(5)*(B(5)-X(5))/2;
    Iout = I1 + I2 + I3 + I4 + I5;
    Rof(i) = 1/Iout;
end
end
end
end
end


%% Results
G = 1+(0.5)./Rof;  %Gain vector
x = [0:2^5-1]'; %Code vector
minRof = min(Rof)
[maxGain maxGain_code] = max(G);
maxGain
maxGain_code = maxGain_code - 1 

%Plots
%Figure 1
figure; plot(x, Rof);
hold on; plot(maxGain_code, minRof, 'r*');
title('Code vs. Ros'); xlabel('Code'); ylabel('Ros');
text(maxGain_code*(1/2), 1.2, 'Min Ros = 0.452 @ Code = 31')

%Figure 2
figure; plot (x, G);
hold on; plot(maxGain_code, maxGain, 'r*');
title('Code vs. Vos Gain'); xlabel('Code'); ylabel ('Vos Gain: (.25)/(Ros)');
text(maxGain_code*(1/4), 2, 'Max Gain = 2.1055 @ Code = 31')

p = polyfit(x, G, 1);
y = p(1)*x + p(2);
plot(x, y, 'r.');

%Figure 3
figure; plot(x, G-y);
maxINL = max(G-y);
minINL = min(G-y);
title('INL of Vos Gain'); xlabel('Code'); ylabel('Gain - Line of best fit');
axis tight

