module lmk_spi_reg 
 (input REG0,
  input REG1,
  input REG2,
  input REG3,
  input REG4,
  input REG5,
  input REG6,
  input REG7,
  input REG8,
  input REG9,
  input REG10,
  input REG11,
		
  input rstn,
  input restart,
  
  input pclk,
  input pen,
  input pwr,
  input [4:0] paddr,
  input [15:0]  pwdata,
  output [15:0] prdata,
  
  output d,
  output c,
  output enl,
  output lmk_sync,
  output lmk_done
  );

  wire [3:0] clk_cnt;

  reg [15:0]  apb_read_data;
  wire [5:0]  bit_num, bit_num_d;
  wire [3:0]  reg_num;
  wire [31:0] reg_wire[0:11];
  wire 	      bit_done, reg_done, startn;
  reg [31:0]  shift_out;
  wire [31:0]  data_out;

  always @(*)
    case(reg_num)
      4'h0 : shift_out = REG0;
      4'h1 : shift_out = REG1;
      4'h2 : shift_out = REG2;
      4'h3 : shift_out = REG3;
      4'h4 : shift_out = REG4;
      4'h5 : shift_out = REG5;
      4'h6 : shift_out = REG6;
      4'h7 : shift_out = REG7;
      4'h8 : shift_out = REG8;
      4'h9 : shift_out = REG9;
      4'hA : shift_out = REG10;
      4'hB : shift_out = REG11;
      default : shift_out = REG0;
    endcase // case(reg_num)
           		 
  counter #(4) clk_cntr (clk_cnt, , 4'h0, 4'hf, pclk, rstn, 1'b1, 1'b1);
  counter #(6) prog_seq_bits (bit_num, bit_done, 6'h0, 6'h3f, clk_cnt[3], (rstn && (!restart)), 1'b1, (reg_num!=4'hB));
  counter #(4) prog_seq_reg (reg_num, reg_done, 4'h0, 4'hB, clk_cnt[3], (rstn && (!restart)), bit_done, 1'b0);
  ffas #(6) bit_num_dly (bit_num_d, bit_num, 6'h0, clk_cnt[3], rstn);
  ffas #(1) start_dly (startn, (rstn && !restart), 1'b0, clk_cnt[3], rstn);

  assign enl = ~(bit_num_d[5] ^ lmk_sync);
  assign c   = (!bit_num_d[5] && startn) && ~clk_cnt[3];
  assign d   = (startn ^ bit_num_d[5]) && shift_out[~bit_num_d[4:0]];
  assign lmk_sync = !(reg_done && (bit_num_d[5] && ((&bit_num_d[2:1]) | (|bit_num_d[4:3]))));
  assign lmk_done = reg_done && bit_done;
  
endmodule // lmk_spi_reg

// Local Variables:
// verilog-library-directories : (".")
// End:
