%This file supports both the iTCM and TCM topologies
%iTCM: integrated triangular current mode
%TCM: triangular current mode
Topology = 'iTCM'; 

%Voltage loop reference
Vref = 400; 
%Output voltage initial condition
Vout_init = 400; 

%RMS input voltage
Vrms  = 230;
%Line frequency
f_in  = 60; 

%iTCM low frequency inductor
L_lf0 = 142.5e-6; 
%DCR of the iTCM low frequency inductor
RL_lf = 0.03; 
%iTCM high frequency inductor
L_hf = 15e-6; 
%DCR of the iTCM high frequency inductor
RL_hf = 0.03; 

%In order to facilitate easy comparison between iTCM and TCM
%the following code calculates the equivalent inductance required for 
%operation. L_eq is also used by the control algorithm. 
%In iTCM operation L_lf is the larger inductor and L_hf is the smaller inductor.
%In TCM L_lf is considered part of the EMI filter whereas L_hf is the boost inductor.
if strcmp(Topology, 'iTCM')
    L_lf = L_lf0;
    L_eq = L_hf * L_lf0 / (L_hf + L_lf0);
    top = 2;
else
    L_lf = L_lf0 / 10;
    L_eq = L_hf;
    top = 1;
end

%Output capacitance
Cout = 820e-6*3; 
%Output capacitance esr
esr_out = 100e-3/3;

%Blocking capacitance (input capacitance for TCM)
Cb = 3*0.47e-6; 
%Cb esr
esr_b = 10e-3/3; 

%Number of Phases
Phases = 2; 

%Power level for simulation
Power = 5000; 
%Equivalent load resistance in steady state.
Rout = Vref^2/Power; 

%Rdson of the low frequency PFC FETs
RDS_ON_LF = 19e-3; 
%Low frequency FETs body diode voltage.
VF_LF = 1.5; 
%Low frequency FET Coss
Coss_lf = 1000e-12; 
%Low frequency FET Coss esr
esr_Coss_lf = 0.5; 

%GaN FET Coss
Coss = 430e-12;

%Simulation run time
tend = 1/f_in; 

filename = 'PMP40988_Rev_1_90deg_Control_iTCM_TCM_Customer';
% filename = 'PMP40988_Rev_1_90deg_Control_iTCM_TCM_DC_Input';
if ~bdIsLoaded(filename)
    open_system(filename);
end

simOut = sim(filename);