/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fileutilities;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.image.Image;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

/**
 *
 * @author Nima Eskandari
 */
public final class FileUtilities {
    static public void ShowDialog(String title, String header, String content)
    {
        Alert alert = new Alert(AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        Stage stage = (Stage) alert.getDialogPane().getScene().getWindow();
        stage.getIcons().add(new Image(FileUtilities.class.getResourceAsStream("/images/TI_logo_small.png")));
        alert.showAndWait();
    }
    
    static public File ChooseFile(String title, String [] extentions)
    {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        for (String extention : extentions)
        {
            fileChooser.getExtensionFilters().addAll(
                    new FileChooser.ExtensionFilter(
                            extention.substring(1).toUpperCase() + " File", "*" + extention));
        }
        File file = fileChooser.showOpenDialog(null);
        return file;
    }
    
    static public File ChooseFolder()
    {
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle("Select Folder");
        File selectedDirectory = chooser.showDialog(null);
        return selectedDirectory;
    }
}
