/**********************************************************************
* Function: main()                                                    *
* Description: main function for PWM/DAC example                      *
* Device: TMS320F2808, TMS320F2806, TMS320F2801                       *
* Author: David M. Alter, Texas Instruments Inc.                      *
* Function Prototype: void main(void)                                 *
* Useage: N/A                                                         *
* Input Parameters: none                                              *
* Return Value: none                                                  *
* Notes: none                                                         *
* History:                                                            *
*   02/07/06 - original (D. Alter)                                    *
*********************************************************************/
#include "DSP280x_Device.h"					// Peripheral address definitions
#include "f2808_HRPWM_DAC.h"				// Include file specific to this project

//---------------------------------------------------------------------
// Global Variables used by HRPWM SFO functions
//
volatile struct EPWM_REGS *ePWM[] = {&EPwm1Regs, &EPwm2Regs, &EPwm3Regs,
                                     &EPwm4Regs, &EPwm5Regs, &EPwm6Regs};

int16 MEP_ScaleFactor[5] = {0,0,0,0,0}; 	// HRPWM Scale Factor values for ePWM1-4


//---------------------------------------------------------------------
void main(void)
{

//*** CPU Initialization
	InitSysCtrl();							// Initialize the CPU (FILE: SysCtrl.c)
	InitGpio();								// Initialize the shared GPIO pins (FILE: Gpio.c)
	InitPieCtrl();							// Initialize and enable the PIE (FILE: PieCtrl.c)

//*** PWM/DAC Initialization

// Do the initial HRPWM calibration.
//
// In this example, one ePWM HRPWM module is being used as the calibrator,
// under the assumption that the other ePWM modules are all similar.  For
// more information, see the "TMS320x280x High-Resolution Pulse Width
// Modulator (HRPWM) Reference Guide," Literature #SPRU924.
	while ( MEP_ScaleFactor[HRPWM_CAL_CH] == 0 ) SFO_MepDis(HRPWM_CAL_CH);

// Setup the ePWM for the DAC function
	InitDac(DAC1_pin, DAC1_period);

//*** Enable the clocks to the ePWM module
// Note: this should be done after all ePWM modules are configured to
// ensure synchronization between the ePWM modules.
	asm(" EALLOW");							// Enable EALLOW protected register access
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;	// HSPCLK to ePWM modules enabled
	asm(" EDIS");							// Disable EALLOW protected register access

//*** Configure CPU Timer0
	InitTimer0();

//*** Enable interrupts
    SetDBGIER(IER);							// Configure the DBGIER for realtime debug
    asm(" CLRC INTM, DBGM");				// Enable global interrupts and realtime debug

//*** Main Loop
	while(1)								// Dummy loop.  Wait for an interrupt.
	{
		SFO_MepDis(HRPWM_CAL_CH);			// Continuously do the HRPWM calibration in the background loop
	}

} //end of main()

/*** end of file *****************************************************/
