******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74ALVCH16827
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2007, (C) COPYRIGHT 2007, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74alvch16827.inc'
X__SN74ALVCH16827 X_1NOE1 X_1Y1 X_1Y2 GND X_1Y3 X_1Y4 VCC X_1Y5 X_1Y6 X_1Y7
+ GND X_1Y8 X_1Y9 X_1Y10 X_2Y1 X_2Y2 X_2Y3 GND X_2Y4 X_2Y5 X_2Y6 VCC X_2Y7
+ X_2Y8 GND X_2Y9 X_2Y10 X_2NOE1 X_2NOE2 X_2A10 X_2A9 GND X_2A8 X_2A7 VCC X_2A6
+ X_2A5 X_2A4 GND X_2A3 X_2A2 X_2A1 X_1A10 X_1A8 X_1A9 GND X_1A7 X_1A6 X_1A5
+ VCC X_1A4 X_1A3 GND X_1A2 X_1A1 X_1NOE2 SN74ALVCH16827
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT=0.9 $ input threshold voltage
.param PMAX=30ns $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+80n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 X_1NOE1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 38ns 80ns


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 X_1A1 0 pulse 'PVIN' 0 'PDELAY1' 'PRFT' 'PRFT' 18ns 40ns


* CHANGE TO THE OUTPUT NODE
VDATA X_1Y1 DATA DC 0
RLOAD DATA VCC 500

* VOLTAGE SUPPLIES

.param PVCC=1.8
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 X_1NOE1 0 1G
* R1G_2 X_1Y1 0 1G
R1G_3 X_1Y2 0 1G
* R1G_4 GND 0 1G
R1G_5 X_1Y3 0 1G
R1G_6 X_1Y4 0 1G
* R1G_7 VCC 0 1G
R1G_8 X_1Y5 0 1G
R1G_9 X_1Y6 0 1G
R1G_10 X_1Y7 0 1G
* R1G_11 GND 0 1G
R1G_12 X_1Y8 0 1G
R1G_13 X_1Y9 0 1G
R1G_14 X_1Y10 0 1G
R1G_15 X_2Y1 0 1G
R1G_16 X_2Y2 0 1G
R1G_17 X_2Y3 0 1G
* R1G_18 GND 0 1G
R1G_19 X_2Y4 0 1G
R1G_20 X_2Y5 0 1G
R1G_21 X_2Y6 0 1G
* R1G_22 VCC 0 1G
R1G_23 X_2Y7 0 1G
R1G_24 X_2Y8 0 1G
* R1G_25 GND 0 1G
R1G_26 X_2Y9 0 1G
R1G_27 X_2Y10 0 1G
R1G_28 X_2NOE1 0 1G
R1G_29 X_2NOE2 0 1G
R1G_30 X_2A10 0 1G
R1G_31 X_2A9 0 1G
* R1G_32 GND 0 1G
R1G_33 X_2A8 0 1G
R1G_34 X_2A7 0 1G
* R1G_35 VCC 0 1G
R1G_36 X_2A6 0 1G
R1G_37 X_2A5 0 1G
R1G_38 X_2A4 0 1G
* R1G_39 GND 0 1G
R1G_40 X_2A3 0 1G
R1G_41 X_2A2 0 1G
R1G_42 X_2A1 0 1G
R1G_43 X_1A10 0 1G
R1G_44 X_1A8 0 1G
R1G_45 X_1A9 0 1G
* R1G_46 GND 0 1G
R1G_47 X_1A7 0 1G
R1G_48 X_1A6 0 1G
R1G_49 X_1A5 0 1G
* R1G_50 VCC 0 1G
R1G_51 X_1A4 0 1G
R1G_52 X_1A3 0 1G
* R1G_53 GND 0 1G
R1G_54 X_1A2 0 1G
* R1G_55 X_1A1 0 1G
R1G_56 X_1NOE2 0 1G

.END
