******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74LV00A
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2005, (C) COPYRIGHT 2005, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.

************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
 .OPTIONS POST                $ Enables HSPLOT interface
 .OPTIONS ACCT OPTS           $ Prints stats & option values used
 .OPTIONS SPICE=1             $ Forces Berkeley compatibility
 .OPTIONS GMIN=1E-12          $ Lowest allowable conductance values
 .OPTIONS GMINDC=1E-12
 .OPTIONS ITL1=400            $ Maximum DC iteration limit
 .OPTIONS ITL4=40             $ Maximum transient iterations/timestep
 .OPTIONS ITL5=0              $ No limit to total transient iterations



***********************************************************************
***********************************************************************
	.OPTIONS search='./'

* ENCRYPTED DEVICE NETLIST and PROCESS Models. 
*INSTRUCTION- Please remove the comment character (*) from the encrypted device net-list 
* and from any one of the corresponding encrypted nominal, strong and weak  file when testing
* the encrypted net-lits and process file

*Please include any one of the package. You need to change the corresponding package sub-*circuit name for connection.

.INCLUDE out.inc

*.INCLUDE  SOIC14.PKG
.INCLUDE  ssop14.pkg
*.INCLUDE  TVSOP14.PKG
*.INCLUDE  PDIP14.PKG

.INCLUDE nom.bsim3.lib
*.INCLUDE weak.bsim3.lib
*.INCLUDE strong.bsim3.lib

***********************************************************************
* Refer to the data sheet for node description.
*


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
xlv00a

+x_1a       
+x_1b
+x_1y
+cgnd
+cvcc


+lv00a__bit

***********************************************************************
******Supply Voltages
***********************************************************************

vcgnd		cgnd	0  dc  0
Vcvcc		cvcc  0  dc 5

***********************************************************************
******Subcircuit for package connection
***********************************************************************

.SUBCKT lv00a  

+p_1a		$PIN 01
+p_1b		$PIN 02
+p_1y	        $PIN 03
+p_cgnd		$PIN 07
+p_cvcc		$PIN 14


X_PIN01      	p_1a      	1a  	D14_01
X_PIN02      	p_1b      	1b  	D14_02
X_PIN03		p_1y		1y	D14_03
X_PIN07		p_cgnd		cgnd	D14_07
X_PIN14		p_cvcc		cvcc	D14_14
 
 
X_lv00a__bit  1a 1b 1y cgnd cvcc  lv00a__bit
.ENDs lv00a

***********************************************************************
***********************************************************************
.temp 50
.param biashv=5v
.param biaslv=0.0
.param supplyv=5v
.param capload=50p
.param resload =500
.param loadv=6

V_load load 0 DC loadv
***********************************************************************
.TRAN         1NS 100NS
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

V1a	   x_1a	   cgnd	PULSE (0  5 5NS  1NS  1NS  20NS  50ns)
V1b        x_1b    cgnd PULSE (0  5 5NS  1NS  1NS  40NS  100ns) 
R_LOAD     x_1y    cgnd     	resload
C_LOAD     x_1y    cgnd     	capload
.END
