******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74TVC3010
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2005, (C) COPYRIGHT 2005, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74tvc3010.inc'
X__SN74TVC3010 GND A1 A2 A3 A4 A5 A6 A7 A8 A9 A10 A11 B11 B10 B9 B8 B7 B6 B5
+ B4 B3 B2 B1 GATE SN74TVC3010
*** PULSE PARAMETERS ***
.param PFREQ1=10MEG $ 1st pulse (clk) frequency
.param PRFT19=2ns $ rise/fall time
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage
.param PVT=1.7 $ input threshold voltage
.param PMAX=2ns $ max SPICE delay time
.param PRFT='(PRFT19/0.8)' $ convert rise/fall time to 100$
.param PPD1='(1/PFREQ1)' $ period of 1st pulse
.param PPW1='((PPD1 - (PRFT*2))/2)' $ pulse width of 1st pulse

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+PMAX+20n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT

*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VI0 A1 0 pulse 0 'PVIN' 'PDELAY1' 'PRFT' 'PRFT' 'PPW1' 'PPD1'
VC1 GATE 0 DC 'PVCC' $ on
*VC1 GATE 0 DC 0V  $ off

* CHANGE TO THE OUTPUT NODE
VDATA B1 DATA DC 0
RLOAD DATA VCC 500

* VOLTAGE SUPPLIES
.param PVCC=5.0
.param PGND=0v
VGND GND 0 'PGND'

.TEMP 40


* RESISTORS TO PREVENT DANGLING NODES
*R1G_1 GND 0 1G
*R1G_2 A1 0 1G
R1G_3 A2 0 1G
R1G_4 A3 0 1G
R1G_5 A4 0 1G
R1G_6 A5 0 1G
R1G_7 A6 0 1G
R1G_8 A7 0 1G
R1G_9 A8 0 1G
R1G_10 A9 0 1G
R1G_11 A10 0 1G
R1G_12 A11 0 1G
R1G_13 B11 0 1G
R1G_14 B10 0 1G
R1G_15 B9 0 1G
R1G_16 B8 0 1G
R1G_17 B7 0 1G
R1G_18 B6 0 1G
R1G_19 B5 0 1G
R1G_20 B4 0 1G
R1G_21 B3 0 1G
R1G_22 B2 0 1G
*R1G_23 B1 0 1G
*R1G_24 GATE 0 1G

.END
