*****************************************************************************
* (C) Copyright 2011 Texas Instruments Incorporated. All rights reserved.
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers makeno warranties, either expressed
** or implied, with respect to thismodel, including the warranties of
** merchantability or fitness fora particular purpose. The model is
** provided solely on an "as is" basis. The entirerisk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part:        TS3A225E
*
* Date:        2011-09-15
* Model Type:  HSPICE
* Simulator:   HSPICE -- E-2010.12 32-BIT (Nov 20 2010) linux
*
*****************************************************************************


* .subckt TS3A225E_fast addr sleeve dettrigger micn micp tip_sense micpresentb
* +sleeve_sense vdd gnd ring2 ring2_sense sda scl
* .ends TS3A225E_fast


.PROBE TRAN
+    I(v5)
+    I(v6)
+    I(r1)
+    I(r2)

.TEMP 25
.TRAN 100e-9 10e-3 START=0.0

.OP

.OPTION
+ CONVERGE=1
+ ACCT  
+ OPTS
+ POST 
+ SCALE=1e-6
+ METHOD=GEAR

*****************************************************************************
.INCLUDE "process_models_linux.lib"
.INCLUDE "TS3A225E_subckts_linux.sp"
*****************************************************************************


v5  vdd    0  DC=2.7    PWL 0 0 1e-3 2.7    TD=0
v6  net025 0  DC=500e-3 PWL 0 0 1e-6 500e-3 TD=5e-3
v0  net027 0  DC=500e-3 PWL 0 0 1e-6 500e-3 TD=5e-3
r2  sleeve net025 1e-3
r1  ring2  net027 1e-3
r9  vdd    net10  1e3
r0  vdd    net7   1e3
v7  gnd    0      DC=0
xesdpadring0 gnd SLEEVE gnd MICn MICp net11 net12 net23 vdd gnd RING2 net22 net10 net7 TS3A225E_fast
.END
